package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsWplan;
import org.jeecg.modules.iost.ims.entity.ImsWplanOuts;
import org.jeecg.modules.iost.ims.kingdeeapi.WplanOutsKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWplanOutsMapper;
import org.jeecg.modules.iost.ims.service.IImsWplanOutsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 委外ERP工单
 * @Author: jeecg-boot
 * @Date:   2021-10-05
 * @Version: V1.0
 */
@Service
public class ImsWplanOutsServiceImpl extends ServiceImpl<ImsWplanOutsMapper, ImsWplanOuts> implements IImsWplanOutsService {
    @Autowired
    WplanOutsKingdeeApi wplanOutsKingdeeApi;

    /**
     * 手动获取金蝶云委外订单数据
     * @param mapjson
     * @return
     */
    @Override
    public Map<String,Object> getData(List<Map<String,Object>> mapjson) throws ParseException {
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsWplanOuts> pojolist=new ArrayList<>();
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        //记录IMS日志
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(mapjson), "ERP委外工单信息", "WPLAN_OUTS");
        for(Map<String,Object> maps:mapjson) {
            //获取委外订单编码
            String poId = maps.get("ERP_MO").toString();
            Map<String, String> idmap = new HashMap<>();
            //将对应的参数设置成金蝶云的查询条件
            idmap.put("FBillNo", poId);

            //从金蝶云获取对应数据
            list1 = wplanOutsKingdeeApi.selectAndLog(idmap, null, "ERP委外工单信息");
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //将实体信息记录下来
                //判断是否有错误
                if(data.containsKey("false")){
                    map.put("false",data.get("false"));
                    return map;
                }
                ImsWplanOuts pojo = new ImsWplanOuts();
                pojo.setFid(data.get("fid"));
                pojo.setErpMo(data.get("ERP_MO"));
                pojo.setProdId(data.get("PROD_ID"));
                pojo.setPqty(data.get("P_QTY"));
                pojo.setPbDate(data.get("PB_DATE"));
                pojo.setPeDate(data.get("PE_DATE"));
                pojo.setSoId(data.get("SO_ID"));
                pojo.setSoSeq(data.get("SO_SEQ"));
                pojo.setCustId(data.get("CUST_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setPtId(data.get("PT_ID"));
                pojo.setErpMoSeq(data.get("ERP_MO_SEQ"));
                pojo.setIsOuts("Y");
                pojo.setIsImsMo("N");
                pojo.setCreateTime(new Date());
                pojolist.add(pojo);
            }
        }
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //将查询结果封装成JSON
        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }
}
