package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsCustomer;
import org.jeecg.modules.iost.ims.service.IImsCustomerService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: ims客户信息
 * @Author: jeecg-boot
 * @Date:   2021-09-06
 * @Version: V1.0
 */
@Api(tags="客户信息")
@RestController
@RequestMapping("/imsCustomer")
@Slf4j
public class ImsCustomerController extends JeecgController<ImsCustomer, IImsCustomerService> {
	@Autowired
	private IImsCustomerService imsCustomerService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsCustomer
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "ims客户信息-分页列表查询")
	@ApiOperation(value="ims客户信息-分页列表查询", notes="ims客户信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsCustomer imsCustomer,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,String date) {
		QueryWrapper<ImsCustomer> queryWrapper = QueryGenerator.initQueryWrapper(imsCustomer, req.getParameterMap()).orderByDesc("create_time");
		Page<ImsCustomer> page = new Page<ImsCustomer>(pageNo, pageSize);
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsCustomer> pageList = imsCustomerService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param imsCustomer
	 * @return
	 */
	@AutoLog(value = "ims客户信息-添加")
	@ApiOperation(value="ims客户信息-添加", notes="ims客户信息-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody ImsCustomer imsCustomer) {
		imsCustomerService.save(imsCustomer);
		return Result.OK("添加成功！");
	}


    /**
    * 导出excel
    *
    * @param request
    * @param imsCustomer
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsCustomer imsCustomer) {
        return super.exportXls(request, imsCustomer, ImsCustomer.class, "ims客户信息");
    }

	 /**
	  * 同步
	  *
	  * @return
	  * @throws ParseException
	  */
	 @AutoLog(value = "IMS客户信息API-同步")
	 @ApiOperation(value = "IMS客户信息API-同步", notes = "IMS客户信息API-同步")
	 @PostMapping(value = "/synchronization")
	 public Result<?> synchronization() throws ParseException {
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		 Boolean flag=imsCustomerService.synchronization(null,sysUser);
		 if(flag){
			 return Result.OK("同步成功");
		 }
		 return Result.error("同步失败");
	 }

}
