package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.entity.ImsMtrl;
import org.jeecg.modules.iost.ims.service.IImsMtrlService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 物料、成品基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-07
 * @Version: V1.0
 */
@Api(tags="物料、成品基本信息")
@RestController
@RequestMapping("/imsMtrl")
@Slf4j
public class ImsMtrlController extends JeecgController<ImsMtrl, IImsMtrlService> {
	@Autowired
	private IImsMtrlService imsMtrlService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsMtrl
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "物料、成品基本信息-分页列表查询")
	@ApiOperation(value="物料、成品基本信息-分页列表查询", notes="物料、成品基本信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsMtrl imsMtrl,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,String date) {
		QueryWrapper<ImsMtrl> queryWrapper = QueryGenerator.initQueryWrapper(imsMtrl, req.getParameterMap()).orderByDesc("create_time");
		Page<ImsMtrl> page = new Page<ImsMtrl>(pageNo, pageSize);
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsMtrl> pageList = imsMtrlService.page(page, queryWrapper);
		return Result.OK(pageList);
	}


    /**
    * 导出excel
    *
    * @param request
    * @param imsMtrl
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsMtrl imsMtrl) {
        return super.exportXls(request, imsMtrl, ImsMtrl.class, "物料、成品基本信息");
    }

	 /**
	  * 同步
	  *
	  * @return
	  * @throws ParseException
	  */
	 @AutoLog(value = "IMS材料信息API-同步")
	 @ApiOperation(value = "IMS材料信息API-同步", notes = "IMS材料信息API-同步")
	 @PostMapping(value = "/synchronization")
	 public Result<?> synchronization(@RequestBody String id) throws ParseException {
		 LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		 Boolean flag=imsMtrlService.synchronization(id,sysUser);
		 if(flag){
			 return Result.OK("同步成功");
		 }
		 return Result.error("同步失败");
	 }

}
