package org.jeecg.modules.iost.ims.controller;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsSupplier;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.iost.ims.service.IImsSupplierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

/**
 * @Description: ims供应商信息
 * @Author: jeecg-boot
 * @Date:   2021-08-31
 * @Version: V1.0
 */
@Api(tags="供应商基础信息")
@RestController
@RequestMapping("/imsSupplier")
@Slf4j
public class ImsSupplierController extends JeecgController<ImsSupplier, IImsSupplierService> {
    @Autowired
    private IImsSupplierService imsSupplierService;

    /**
     * 分页列表查询
     *
     * @param imsSupplier
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "供应商信息-分页列表查询")
    @ApiOperation(value = "供应商信息-分页列表查询", notes = "供应商信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsSupplier imsSupplier,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req,String date) {
        QueryWrapper<ImsSupplier> queryWrapper = QueryGenerator.initQueryWrapper(imsSupplier, req.getParameterMap()).orderByDesc("create_time");
        Page<ImsSupplier> page = new Page<ImsSupplier>(pageNo, pageSize);
        if(!"null".equals(date)){
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE,1);
            String parse1=sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time",parse);
            queryWrapper.lt("create_time",parse1);
        }
        IPage<ImsSupplier> pageList = imsSupplierService.page(page, queryWrapper);
        return Result.OK(pageList);
    }


    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "IMS供应商信息API-同步")
    @ApiOperation(value = "IMS供应商信息API-同步", notes = "IMS供应商信息API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag=imsSupplierService.synchronization(id,sysUser);
        if(flag){
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }
}