package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;
/**
 * 查询金蝶云其他出库信息
 */
@Component
public class AuditKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "STK_OutStockApply";//出库申请单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public AuditKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//单据编号
        key.put("FBillTypeID.FNumber","FBillTypeID.FNumber");//单据类型
        key.put("FMaterialId.Fnumber","FMaterialId.Fnumber");//物料编码
        key.put("FNote","FNote");//备注
        key.put("FQty","FQty");//实发数量
        key.put("FEntity_FEntryID","FEntity_FEntryID");//明细行内码
        key.put("FEntity_FSeq","FEntity_FSeq");//明细序号
//        key.put("FSrcBillNo","FSrcBillNo");//源单编号
        key.put("FEntity_Link_FSId","FEntity_Link_FSId");//源单分录内码
        key.put("FBusinessEnd","FBusinessEnd");//业务终止状态
        key.put("FDeptId.Fnumber","FDeptId.Fnumber");//领用部门
        key.put("F_ora_Assistant.Fnumber","F_ora_Assistant.Fnumber");//研发项目编码
        key.put("F_ora_Base.Fnumber","F_ora_Base.Fnumber");//领料人编码
    }
    @Override
    public String add(Map json) {
        return null;
    }

    /**
     * 查询根据ID查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return Audit(list);
    }
    /**
     * 查询生产用料清单的数据
     * @param id
     * @return
     */
    public List<List<Object>> getMOID(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("PRD_PPBOM", new HashMap<String, String>() {{
            //根据行内码查询生产订单编号和行号
            put("FMOBillNO", "FMOBillNO");
            put("FMOEntrySeq", "FMOEntrySeq");
            put("FEntity_FEntryID","FEntity_FEntryID");
        }}, new HashMap<String, String>() {{
            put("FEntity_FEntryID", id);
        }});
        if(lists.isEmpty()||"".equals(lists.get(0).get(0).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }

    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> Audit(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        //如果没有出现错误则会返回数据
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> MOIDMap = new HashMap<>();
                String MOID = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("AUDIT_ID", list1.get(1).toString());
                    salesordermap.put("AUDIT_TYPE", list1.get(2).toString());
                    salesordermap.put("MTRL_ID", list1.get(3).toString());
                    salesordermap.put("REMARK", list1.get(4).toString());
                    salesordermap.put("QUANTITY", list1.get(5).toString());
                    salesordermap.put("MTRL_SEQ", list1.get(6).toString());
                    salesordermap.put("fBusinessEnd", list1.get(9).toString().equals("B")?"已终止":"未终止");
                    salesordermap.put("DEPT_ID",list1.get(10).toString());
                    if(null==list1.get(12)){
                        salesordermap.put("NEED_USER","");
                    }else {
                        salesordermap.put("NEED_USER",list1.get(12).toString());
                    }
                    if(null==list1.get(11)){
                        salesordermap.put("ITEM_ID","");
                    }else {
                        salesordermap.put("ITEM_ID",list1.get(11).toString());
                    }
                    //根据源单分录内码查询生产订单编号
                    if(list1.get(8)==null||"".equals(list1.get(8).toString())){
                        salesordermap.put("ERP_MO", "");
                        salesordermap.put("ERP_MO_SEQ","");
                    }else {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //行内码
                        idList.add(list1.get(8).toString());
                        //主键ID
                        MOIDMap.put(list1.get(6).toString(), idList);
                        //拼接id做批量查询
                        MOID = "'"+list1.get(8).toString() + "'," + MOID;
                        salesordermap.put("FEntity_Link_FSId",list1.get(8).toString());
                    }
                    salesorderlist.add(salesordermap);
                }
                if(!"".equals(MOID)){
                    //批量查出所有生产用料清单的数据
                    MOID=MOID.substring(0,MOID.length()-1);
                    List<List<Object>> materid = getMOID(MOID);
                    if (null == materid || "".equals(materid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("ERP_MO", "");
                            salesordermap.put("ERP_MO_SEQ","");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : MOIDMap.keySet()) {
                            for(List materList: materid){
                                //如果对应的行内码相同
                                if (MOIDMap.get(fid).get(0).equals(materList.get(0).toString())) {
                                    //将信息添加到集合
                                    MOIDMap.get(fid).add(materList.get(1).toString());
                                    MOIDMap.get(fid).add(materList.get(2).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : MOIDMap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("MTRL_SEQ"))&&MOIDMap.get(fid).get(0).equals(salesordermap.get("FEntity_Link_FSId"))) {
                                    //如果对应的编码不为空
                                    if (null != MOIDMap.get(fid).get(1)) {
                                        salesordermap.put("ERP_MO", MOIDMap.get(fid).get(1));
                                        salesordermap.put("ERP_MO_SEQ", MOIDMap.get(fid).get(2));
                                    } else {
                                        salesordermap.put("ERP_MO", "");
                                        salesordermap.put("ERP_MO_SEQ","");
                                    }
                                }
                            }
                        }
                    }
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
