package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import net.sf.json.JSONObject;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsMtrl;
import org.jeecg.modules.iost.ims.entity.ImsSupplier;
import org.jeecg.modules.iost.ims.kingdeeapi.MtrlKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.SupplierKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsMtrlMapper;
import org.jeecg.modules.iost.ims.mapper.ImsSupplierMapper;
import org.jeecg.modules.iost.ims.service.IImsMtrlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 物料、成品基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-07
 * @Version: V1.0
 */
@Service
public class ImsMtrlServiceImpl extends ServiceImpl<ImsMtrlMapper, ImsMtrl> implements IImsMtrlService {
    @Autowired
    MtrlKingdeeApi mtrlKingdeeApi;
    @Autowired
    IMSApi imsApi;

    @Override
    public JSONObject add(Map<String, String> map) {
        return null;
    }

    @Override
    public JSONObject select(Map<String, String> map) {
        return null;
    }

    /**
     * 从金蝶云同步物料信息
     * @param object
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        List<ImsMtrl> pojolist=new ArrayList<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        idmap.put("FMATERIALID",object.toString());
            list = mtrlKingdeeApi.selectAndLog(idmap, null,"物料信息");
            //遍历集合拿到所有的MAP
            for (Map<String, String> data : list) {
                //判断是否有错误
                if(data.containsKey("false")){
                    return success;
                }
                //将实体信息记录下来
                ImsMtrl pojo = new ImsMtrl();
                pojo.setFid(data.get("fid"));
                pojo.setDisable(data.get("DISABLE"));
                pojo.setMtrlId(data.get("MTRL_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setMtrlName(data.get("MTRL_NAME"));
                pojo.setMtrlGroup(data.get("MTRL_GROUP"));
                pojo.setProdMtype(Integer.parseInt(data.get("PROD_MTYPE")));
                pojo.setMunit(data.get("MUNIT"));
                pojo.setPackQty(Double.valueOf(data.get("PACK_QTY")).intValue());
                pojo.setStoreId(data.get("STORE_ID"));
                pojo.setCreateTime(new Date());
                pojo.setMtrlDesc(data.get("MTRL_DESC"));
                pojo.setIsAdmit(data.get("IS_ADMIT"));
                if(sysUser!=null){
                    pojo.setCreateBy(sysUser.getUsername());
                    pojo.setSysOrgCode(sysUser.getOrgCode());
                }
                pojolist.add(pojo);
            }
                //将数据信息 存放到数据库
                this.saveBatch(pojolist);
                //将数据包装成IMS格式
                Map<String,Object> map=new HashMap<>();
                map.put("success","true");
                map.put("message","操作成功");
                map.put("result", list);
                String mapjson = JsonUtil.Mapjson(map);
                String request=JsonUtil.Listjson(list);
                String body = ImsUtil.getIms("TB_BS_MTRL",mapjson);
                //IMS同步
                String result = imsApi.add(body);
                //记录IMS日志
                Boolean flag = imsLogUtil.ImsLog(body,result, "物料信息","TB_BS_MTRL");
//                设置同步成功状态
                success=flag;
//                success=true;
        return success;
    }

    @Override
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        return null;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = mtrlKingdeeApi.queryList(null, null, "物料信息分页查询", pageNo, pageSize);
        return list;
    }
}
