package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsWplanMn;
import org.jeecg.modules.iost.ims.entity.ImsXcl;
import org.jeecg.modules.iost.ims.kingdeeapi.XclKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsXclMapper;
import org.jeecg.modules.iost.ims.service.IImsXclService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ERP库存查询接口
 * @Author: jeecg-boot
 * @Date: 2021-10-05
 * @Version: V1.0
 */
@Service
public class ImsXclServiceImpl extends ServiceImpl<ImsXclMapper, ImsXcl> implements IImsXclService {

    @Autowired
    XclKingdeeApi xclKingdeeApi;

    /**
     * 手动获取金蝶云ERP库存信息
     *
     * @param mapjson
     * @return
     */
    @Override
    public Map<String,Object> getData(List<Map<String,Object>> mapjson) throws ParseException {
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsXcl> pojolist = new ArrayList<>();
        KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
        //记录IMS日志
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(mapjson), "ERP库存查询接口", "XCL");
        for (Map<String,Object> maps : mapjson) {
            //获取委外用料订单编码
            //如果仓库编码或者组织编码为空则直接返回
            if ( maps.get("STORE_ID") == null || "".equals( maps.get("STORE_ID").toString()) ||maps.get("ORG_ID") == null || "".equals(maps.get("ORG_ID").toString())) {
                String msg = "仓库编码或组织编码为必填内容";
                map.put("flase",msg);
                return map;
            }
            String store_id = maps.get("STORE_ID").toString();
            int pageNo =0;
            if(null!=maps.get("pageNo")||!"".equals(maps.get("pageNo").toString())){
                 pageNo = Integer.parseInt(maps.get("pageNo").toString()) ;
            }
            int pageSize =0;
            if(null!=maps.get("pageSize")||!"".equals(maps.get("pageSize").toString())){
                pageSize = Integer.parseInt(maps.get("pageSize").toString()) ;
            }
            //查询出组织ID
            String org_id = maps.get("ORG_ID").toString();
            Map<String, String> idmap = new HashMap<>();
            //将对应的参数设置成金蝶云的查询条件
            idmap.put("FStockId.Fnumber", store_id);
            idmap.put("FStockOrgId.Fnumber",org_id);
            if (maps.get("MTRL_ID")!=null&&!"".equals(maps.get("MTRL_ID").toString())){
                String  mtrl_id = maps.get("MTRL_ID").toString();
                idmap.put("FMaterialId.Fnumber",mtrl_id);
            }
            //从金蝶云获取对应数据
            list1 = xclKingdeeApi.queryList(idmap, null, "ERP库存查询接口",pageNo,pageSize);
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //将实体信息记录下来
                //判断是否有错误
                if(data.containsKey("false")){
                    map.put("false",data.get("false"));
                    return map;
                }
                ImsXcl pojo = new ImsXcl();
                pojo.setFid(data.get("fid"));
                pojo.setMtrlId(data.get("MTRL_ID"));
                pojo.setStoreId(store_id);
                pojo.setBlQty(data.get("BL_QTY"));
                pojo.setCreateTime(new Date());
                pojolist.add(pojo);
            }
        }
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //将查询结果封装成JSON
        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }
}
