package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.entity.ImsPoRejection;
import org.jeecg.modules.iost.ims.service.IImsPoRejectionService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: IMS采购拒收
 * @Author: jeecg-boot
 * @Date:   2021-12-10
 * @Version: V1.0
 */
@Api(tags="IMS采购拒收")
@RestController
@RequestMapping("/imsPoRejection")
@Slf4j
public class ImsPoRejectionController extends JeecgController<ImsPoRejection, IImsPoRejectionService> {
	@Autowired
	private IImsPoRejectionService imsPoRejectionService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsPoRejection
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-分页列表查询")
	@ApiOperation(value="IMS采购拒收-分页列表查询", notes="IMS采购拒收-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsPoRejection imsPoRejection,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,@RequestParam(name="date")String date) {
		QueryWrapper<ImsPoRejection> queryWrapper = QueryGenerator.initQueryWrapper(imsPoRejection, req.getParameterMap());
		Page<ImsPoRejection> page = new Page<ImsPoRejection>(pageNo, pageSize);
		queryWrapper.orderByDesc("create_time");
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsPoRejection> pageList = imsPoRejectionService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param imsPoRejection
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-添加")
	@ApiOperation(value="IMS采购拒收-添加", notes="IMS采购拒收-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody ImsPoRejection imsPoRejection) {
		imsPoRejectionService.save(imsPoRejection);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param imsPoRejection
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-编辑")
	@ApiOperation(value="IMS采购拒收-编辑", notes="IMS采购拒收-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody ImsPoRejection imsPoRejection) {
		imsPoRejectionService.updateById(imsPoRejection);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-通过id删除")
	@ApiOperation(value="IMS采购拒收-通过id删除", notes="IMS采购拒收-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		imsPoRejectionService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-批量删除")
	@ApiOperation(value="IMS采购拒收-批量删除", notes="IMS采购拒收-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.imsPoRejectionService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "IMS采购拒收-通过id查询")
	@ApiOperation(value="IMS采购拒收-通过id查询", notes="IMS采购拒收-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		ImsPoRejection imsPoRejection = imsPoRejectionService.getById(id);
		if(imsPoRejection==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(imsPoRejection);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param imsPoRejection
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsPoRejection imsPoRejection) {
        return super.exportXls(request, imsPoRejection, ImsPoRejection.class, "IMS采购拒收");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsPoRejection.class);
    }

}
