package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.entity.ImsPurchase;
import org.jeecg.modules.iost.ims.service.IImsPurchaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 采购订单收料入库
 * @Author: jeecg-boot
 * @Date:   2021-10-06
 * @Version: V1.0
 */
@Api(tags="采购订单收料入库")
@RestController
@RequestMapping("/imsPurchase")
@Slf4j
public class ImsPurchaseController extends JeecgController<ImsPurchase, IImsPurchaseService> {
	@Autowired
	private IImsPurchaseService imsPurchaseService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsPurchase
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "采购订单收料入库-分页列表查询")
	@ApiOperation(value="采购订单收料入库-分页列表查询", notes="采购订单收料入库-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsPurchase imsPurchase,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,String date) {
		QueryWrapper<ImsPurchase> queryWrapper = QueryGenerator.initQueryWrapper(imsPurchase, req.getParameterMap()).orderByDesc("create_time");
		Page<ImsPurchase> page = new Page<ImsPurchase>(pageNo, pageSize);
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsPurchase> pageList = imsPurchaseService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	 /**
	  * 采购订单收料入库
	  *
	  * @return
	  * @throws ParseException
	  */
	 @AutoLog(value = "采购订单收料入库")
	 @ApiOperation(value = "采购订单收料入库", notes = "采购订单收料入库")
	 @PostMapping(value = "/setData")
	 public Result<?> setData(List<Map<String, Object>> list,String code) throws ParseException {
		 String s = imsPurchaseService.setData(list,code);
		 return Result.OK(s,"采购订单收料入库");
	 }

}
