package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 工时汇报(按实际需求定制)
 * @Author: jeecg-boot
 * @Date:   2021-09-27
 * @Version: V1.0
 */
@Data
@TableName("ims_tkwbg")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_tkwbg对象", description="工时汇报(按实际需求定制)")
public class ImsTkwbg implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**唯一序号*/
	@Excel(name = "唯一序号", width = 15)
    @ApiModelProperty(value = "唯一序号")
    private java.lang.Integer queueId;
	/**交易时间*/
	@Excel(name = "交易时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "交易时间")
    private java.util.Date trxDate;
	/**ERP工单编码*/
	@Excel(name = "ERP工单编码", width = 15)
    @ApiModelProperty(value = "ERP工单编码")
    private java.lang.String erpMo;
	/**ERP工单行号*/
	@Excel(name = "ERP工单行号", width = 15)
    @ApiModelProperty(value = "ERP工单行号")
    private java.lang.String erpMoSeq;
	/**合格数量*/
	@Excel(name = "合格数量", width = 15)
    @ApiModelProperty(value = "合格数量")
    private Integer passQty;
	/**不合格数量*/
	@Excel(name = "不合格数量", width = 15)
    @ApiModelProperty(value = "不合格数量")
    private Integer ngQty;
	/**待返修数量*/
	@Excel(name = "待返修数量", width = 15)
    @ApiModelProperty(value = "待返修数量")
    private Integer repairQty;
	/**报废数量*/
	@Excel(name = "报废数量", width = 15)
    @ApiModelProperty(value = "报废数量")
    private Integer scrapQty;
	/**返工数量*/
	@Excel(name = "返工数量", width = 15)
    @ApiModelProperty(value = "返工数量")
    private Integer reworkQty;
	/**完成数量*/
	@Excel(name = "完成数量", width = 15)
    @ApiModelProperty(value = "完成数量")
    private Integer completeQty;
	/**人员实作工时(小时)*/
	@Excel(name = "人员实作工时(小时)", width = 15)
    @ApiModelProperty(value = "人员实作工时(小时)")
    private Integer personTime;
	/**机器实作工时(小时)*/
	@Excel(name = "机器实作工时(小时)", width = 15)
    @ApiModelProperty(value = "机器实作工时(小时)")
    private Integer devTime;
	/**开始时间*/
	@Excel(name = "开始时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间")
    private java.util.Date stratDate;
	/**结束时间*/
	@Excel(name = "结束时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
    private java.util.Date endDate;

    /**fid*/
    @Excel(name = "fid", width = 15)
    @ApiModelProperty(value = "fid")
    private String fid;
    /**单据编码*/
    @Excel(name = "单据编码", width = 15)
    @ApiModelProperty(value = "单据编码")
    private String fbillNo;
    /**单据体内码-分录*/
    @Excel(name = "单据体内码-分录", width = 15)
    @ApiModelProperty(value = "单据体内码-分录")
    private String fentryId;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
}
