package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 查询金蝶云物料基本信息
 */
@Component
public class MtrlKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "BD_MATERIAL";//基本资料-物料
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public MtrlKingdeeApi() {
        /*查询字段*/
        key.put("FMATERIALID", "FMATERIALID");//单据头实体主键
        key.put("FNumber", "FNumber");//编码
        key.put("FName", "FName");//名称
        key.put("FForbidStatus", "FForbidStatus");//禁用状态
        key.put("FUseOrgId.Fnumber", "FUseOrgId.Fnumber");//使用组织
        key.put("FMaterialGroup.Fnumber", "FMaterialGroup.Fnumber");//物料分组名
        key.put("FErpClsID", "FErpClsID");//物料属性
        key.put("FBaseUnitId.Fnumber", "FBaseUnitId.Fnumber");//基本单位
        key.put("FMinPackCount", "FMinPackCount");//最小包装数
        key.put("FStockId.Fnumber", "FStockId.Fnumber");//仓库id
        key.put("FSpecification", "FSpecification");//规格型号
        key.put("FCreateDate", "FCreateDate");//创建时间
//        key.put("F_LQKJ_admit","F_LQKJ_admit");//承认状态
        key.put("FMaterialGroup", "FMaterialGroup");//物料分组名
    }


    @Override
    public String add(Map json) {
        return null;
    }

//    //删除缓存
//    @CacheEvict(value = "parentid")
//    public void delParentid(){
//
//    }

    /**
     * 查询所有的物料分组
     *
     * @param
     * @return
     */
    public List<List<Object>> getALLParentid() {
        List<List<Object>> lists = categoryDao.select("SAL_MATERIALGROUP", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("Fnumber", "Fnumber");
            put("FPARENTID", "FPARENTID");
            put("Fid", "Fid");
        }}, null);
        return lists;
    }

    /**
     * 查询根据ID查询
     *
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where, String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key, map, name);
        return Mtrl(list);
    }

    /**
     * 分页查询
     *
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */

    public List<Map<String, String>> queryList(Map<String, String> map, String where, String name, Integer pageNo, Integer pageSize) throws ParseException {
        List<List<Object>> list = categoryDao.queryList(sFormId, key, new HashMap<String, String>() {{
            put("FUseOrgId.Fnumber", "100");
        }}, name, pageNo, pageSize);
        return Mtrl(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> Mtrl(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                //遍历所有的物料分组
                List<List<Object>> allParentid = getALLParentid();
                Map<String, List> parentMap = new HashMap<>();
                for (List<Object> parent : allParentid) {
                    List panretList = new ArrayList();
                    //编码
                    panretList.add(parent.get(1).toString());
                    //父级
                    panretList.add(parent.get(2).toString());
                    parentMap.put(parent.get(0).toString(), panretList);
                }
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("MTRL_ID", list1.get(1).toString());
                    salesordermap.put("MTRL_NAME", list1.get(2).toString());
                    if (list1.get(3).toString().equals("A")) {
                        salesordermap.put("DISABLE", "N");
                    } else {
                        salesordermap.put("DISABLE", "Y");
                    }
                    salesordermap.put("ORG_ID", list1.get(4).toString());
                    String PROD_MTYPE = "";

                    if (list1.get(5) == null || "".equals(list1.get(5))) {
                        salesordermap.put("MTRL_GROUP", "");
                    } else {
                        PROD_MTYPE = list1.get(5).toString();
                        String groupid = "";
                        if (list1.get(12) == null || "".equals(list1.get(12).toString())) {
                            salesordermap.put("MTRL_GROUP", "");
                        } else {
                            groupid = list1.get(12).toString();
                            String parentid="";
                            String number="";
                            String parentnumber="";
                            String topnumber="";
                            for (String key: parentMap.keySet()){
                                if(groupid.equals(key)){
                                    //将父级ID赋值
                                    parentid=parentMap.get(key).get(1).toString();
                                    //获取当前的编码
                                    number=parentMap.get(key).get(0).toString();
                                    break;
                                }
                            }
                            //如果第一次的父级就是最顶级那么就传空
                            if ("0".equals(parentid) || parentid == null || "".equals(parentid)) {
                                salesordermap.put("MTRL_GROUP", "");
                            }else {
                                groupid=parentid;
                                //再次查询父级分组
                                for (String key: parentMap.keySet()){
                                    if(groupid.equals(key)){
                                        //将父级ID赋值
                                        parentid=parentMap.get(key).get(1).toString();
                                        //获取父级编码
                                        parentnumber=parentMap.get(key).get(0).toString();
                                        break;
                                    }
                                }
                                //判断
                                if ("0".equals(parentid) || parentid == null || "".equals(parentid)) {
                                    salesordermap.put("MTRL_GROUP", number);
                                } else {
                                    //则往上开始查询
                                    String fid=groupid;
                                    while (true) {
                                        for (String key: parentMap.keySet()){
                                            if(fid.equals(key)){
                                                //将父级ID赋值
                                                parentid=parentMap.get(key).get(1).toString();
                                                topnumber=parentMap.get(key).get(0).toString();
                                                break;
                                            }
                                        }
                                        //当父级为0是跳出循环
                                        if("0".equals(parentid)){
                                            break;
                                        }else {
                                            //否则将父级ID赋值继续循环
                                            fid=parentid;
                                            //将父级编码写成当前编码
                                            number=parentnumber;
                                            //将上两层编码写成父级编码
                                            parentnumber=topnumber;
                                        }
                                    }
                                    salesordermap.put("MTRL_GROUP",number);
                                }
                            }
                        }
                    }
                    salesordermap.put("PROD_MTYPE", list1.get(6).toString());
                    salesordermap.put("MUNIT", list1.get(7).toString());
                    salesordermap.put("PACK_QTY", list1.get(8).toString());
                    if (list1.get(9) == null || "".equals(list1.get(9))) {
                        salesordermap.put("STORE_ID", "");
                    } else {
                        salesordermap.put("STORE_ID", list1.get(9).toString());
                    }
                    salesordermap.put("MTRL_DESC", list1.get(10).toString());
                    salesordermap.put("IS_ADMIT", "N");
                    salesordermap.put("IS_STS", "N");
                    salesordermap.put("MTRL_LEV", "2");
                    salesorderlist.add(salesordermap);
                }
//               delParentid();

            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
