package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsPurchase;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 金蝶云销售退货
 */
@Component
public class SalesreturnKingdeeApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;

    public SalesreturnKingdeeApi() {
        sFormId = "SAL_RETURNSTOCK";  //子单据Formid
        Father_sFormId = "SAL_SaleOrder";  //父单据Formid
        Son_FEnrtyID = "FEntity_FENTRYID";  //子单据要查询的FEntryId
        Father_FEnrtyID = "FSaleOrderEntry_FEntryID";  //父单据要查询的FEntryId
        KingdeeLogPushName = "销售退货单(销售订单下推)";  //金蝶云下推操作日志名称
        KingdeeLogName = "销售退货单";    //金蝶云修改操作日志-name
        push_Rule = "SaleOrder-SalReturnStock";   //父单据下推子单据的规则
        SeqName="FEntity_Link_FSId";  //子单据里面的源单分录内码(父单据行内码);
    }

    @Override
    public String add(Map<String, Object> maps) {
        List<Map<String,Object>> lists=new ArrayList<>();
        lists.add(maps);
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        JSONObject result = categoryDao.addReturn(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        return result.toString();
    }


    public JSONObject addTwo(List<Map<String,Object>> lists) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        JSONObject result = categoryDao.addReturn(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        return result;
    }
    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public LinkedHashMap<String, Object> ImsToKingdee(List<Map<String,Object>> lists) {
        Map<String, Object> FEntityMap = new HashMap<>();
        LinkedHashMap<String, Object> ModelMap = new LinkedHashMap<>();
        List<Map<String, Object>> list = new ArrayList<>();
        /*字段转化*/
        //转换成金蝶云格式
        for (Map<String, Object> maps : lists) {
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_ID"));
            }}); //仓库编码
            FEntityMap.put("FNote", maps.get("REMARK")); //备注
            FEntityMap.put("FKeeperId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //保管者
            //修改条件FEntryID
            FEntityMap.put("FEntryID", maps.get("FEntry_ID"));//本单据的FEntryID
            list.add(FEntityMap);
            //修改条件FID
            ModelMap.put("FID", maps.get("FID"));
            ModelMap.put("FDate", maps.get("TRX_DATE"));//日期
        }
        ModelMap.put("FEntity", list);
        return  ModelMap;

    }

    /*根据FID以及原单行号来查询子单下推下来的FEntity_FEntryId*/
    public List<Object> select(String FenID, String fid) {
        List<List<Object>> fBillNo = categoryDao.select(sFormId, new HashMap<String, String>() {{
            put(Son_FEnrtyID, Son_FEnrtyID);
            put("FEntity_FSeq","FEntity_FSeq");
        }}, new HashMap<String, String>() {{
            put("FID",fid);
            put(SeqName,FenID);
        }});
        return fBillNo.get(0);
    }

    //查询父单据行内码
    public Object select(Map<String,Object> map) {
        List<List<Object>> fBillNo = categoryDao.selectAndLog(Father_sFormId, new HashMap<String, String>() {{
            put(Father_FEnrtyID, Father_FEnrtyID);
        }}, new HashMap<String, String>() {{
            put("FSaleOrderEntry_FSeq",map.get("SO_SEQ").toString());
            put("FBillNo",map.get("SO_ID").toString());
        }},"销售订单行内码查询");
        if(fBillNo.isEmpty()){
            return null;
        }
        return fBillNo.get(0).get(0);
    }
    /*父单据下推到子单据*/
    public List<Map<String, String>> pushMore(List<String> FEntryIDs) {
        //下推单据 将子项-单据转换规则(写死，客户端查询)-目标单据FormId-
        String pushResult = categoryDao.pushMore(KingdeeLogPushName, Father_sFormId, FEntryIDs, push_Rule, sFormId);
        //解析信息，得到返回的本单据的单据编码FID和FBillNo
        JSONObject jsonObject = JSON.parseObject(pushResult);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        //如果为空说明下推失败没得到成功结果
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        if (isSuccess == false) {
            String message = new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(0);
                message = message + "---" + String.valueOf(messags.get("Message"));
            }
            List<Map<String, String>> list = new ArrayList<>();
            Map<String, String> map = new HashMap<>();
            map.put("messgae",String.valueOf(message));
            list.add(map);
            return list;
        } else {
            List<Map<String, String>> list = new ArrayList<>();
            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                list.add(map);
            }
            return list;
        }
    }

    //删除修改失败的单据
    public String delete(String id) {
        String delete = categoryDao.delete(KingdeeLogName, sFormId, id);
        return delete;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
