package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 查询金蝶云仓管信息
 */
@Component
public class StoreKingdeeApi implements web_api {

    /**
     * 操作的单据体名称
     */
    private String sFormId = "BD_STOCK";//库存管理-仓库
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    //静态加载
    public StoreKingdeeApi() {
        /*查询字段*/
        key.put("FStockId", "FStockId");//单据头实体主键
        key.put("FNumber", "FNumber");//编码
        key.put("FName", "FName");//名称
        key.put("FForbidStatus", "FForbidStatus");//禁用状态
        key.put("FUseOrgId.Fnumber", "FUseOrgId.Fnumber");//使用组织
        key.put("FStockStatusType", "FStockStatusType");//库存状态类型
        key.put("FCreateDate", "FCreateDate");//创建时间
    }


    @Override
    public String add(Map json) {
        return null;
    }

    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where, String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key, map, name);
        return Store(list);
    }
    /**
     * 分页查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */

    public List<Map<String, String>> queryList(Map<String, String> map, String where,String name,Integer pageNo,Integer pageSize) throws ParseException {
        List<List<Object>> list = categoryDao.queryList(sFormId, key,map,name,pageNo,pageSize);
        return Store(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> Store(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("STORE_ID", list1.get(1).toString());
                    salesordermap.put("ERP_STORE_ID", list1.get(1).toString());
                    salesordermap.put("STORE_NAME", list1.get(2).toString());
                    if (list1.get(3).toString().equals("A")) {
                        salesordermap.put("DISABLE", "N");
                    } else {
                        salesordermap.put("DISABLE", "Y");
                    }
                    salesordermap.put("ORG_ID", list1.get(4).toString());
                    //获取所有库存状态
                    String s = list1.get(5).toString();
                    if(s==null||"".equals(s)){
                        salesordermap.put("STORE_TYPE","良品");
                    } else if (s.contains("6") || s.contains("7")) {
                        salesordermap.put("STORE_TYPE","不良品");
                    }else {
                        salesordermap.put("STORE_TYPE","良品");
                    }
                    salesordermap.put("STORE_MD", "1");
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
