package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 查询金蝶云ERP委外工单基本信息
 */
@Component
public class WplanOutsKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "SUB_SUBREQORDER";//ERP工单-委外订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public WplanOutsKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//单据编号
        key.put("FMaterialId.FNumber","FMaterialId.FNumber");//物料编码
        key.put("FQty","FQty");//数量
        key.put("FPlanStartDate","FPlanStartDate");//计划开工时间
        key.put("FPlanFinishDate","FPlanFinishDate");//计划完工时间
        key.put("FSALEORDERNO","FSALEORDERNO");//需求单据
        key.put("FSaleOrderEntrySeq","FSaleOrderEntrySeq");//需求单据行号
        key.put("FSubOrgId.FNumber","FSubOrgId.FNumber");//委外组织
        key.put("FCreateDate","FCreateDate");//创建时间
        key.put("FSaleOrderId","FSaleOrderId");//销售订单ID
        key.put("FTreeEntity_FSeq","FTreeEntity_FSeq");//明细序号
        key.put("FTreeEntity_FEntryId","FTreeEntity_FEntryId");//行内码
    }

    @Override
    public String add(Map json) {
        return null;
    }


    /**
     * 获取金蝶云数据
     *
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return WplanOuts(list);
    }
    /**
     * 查询父级的实体主键
     * @param id
     * @return
     */
    public List<List<Object>> getCustid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SAL_SaleOrder", new HashMap<String, String>() {{
            //根据单据编码查询客户ID
            put("FCustId.FNumber", "FCustId.FNumber");
            put("FID","FID");
        }}, new HashMap<String, String>() {{
            put("FID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"".equals(lists.get(0).get(0))){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }


    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> WplanOuts(List<List<Object>> list)  {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        //转换时间格式
        TimeUtil timeUtil=new TimeUtil();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                //添加主键与外键映射关系
                Map<String, List<String>> Custmap = new HashMap<>();
                String cust = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("ERP_MO", list1.get(1).toString());
                    salesordermap.put("PROD_ID", list1.get(2).toString());
                    salesordermap.put("P_QTY", list1.get(3).toString());
                    Date parse = null;
                    Date parse1 = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(4).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pbdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("PB_DATE", pbdate);
                    try {
                        parse1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(5).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pedate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("PE_DATE", pedate);
                    salesordermap.put("SO_ID", list1.get(6).toString());
                    salesordermap.put("SO_SEQ", list1.get(7).toString());
                    salesordermap.put("ORG_ID", list1.get(8).toString());
//            salesordermap.put("ptid",list1.get(9).toString());
                    String s = list1.get(10).toString();
                    if (s == null || " ".equals(s)) {
                        salesordermap.put("CUST_ID", " ");
                    } else {
                        //将行内码和编码存入集合
                        List<String> idList = new ArrayList<>();
                        //编码
                        idList.add(list1.get(10).toString());
                        //行内码
                        Custmap.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        cust = "'"+list1.get(10).toString() + "'," + cust;
                        salesordermap.put("FSaleOrderId",list1.get(10).toString());
                        salesordermap.put("FTreeEntity_FEntryId",list1.get(12).toString());
//                        Object custid = getCustid(list1.get(10).toString());
//                        salesordermap.put("CUST_ID", custid.toString());
                    }
                    salesordermap.put("ERP_MO_SEQ", list1.get(11).toString());
                    salesordermap.put("IS_OUTS","Y");
                    salesordermap.put("IS_IMS_MO","N");
                    salesordermap.put("SUP_ID","");
                    salesorderlist.add(salesordermap);
                }
                if(!"".equals(cust)){
                    //批量查出所有生产用料清单的数据
                    cust=cust.substring(0,cust.length()-1);
                    List<List<Object>> custid = getCustid(cust);
                    if (null == custid || "".equals(custid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("CUST_ID", "");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : Custmap.keySet()) {
                            for(List custList: custid){
                                //如果对应的行内码相同
                                if (Custmap.get(fid).get(0).equals(custList.get(0).toString())) {
                                    //将信息添加到集合
                                    Custmap.get(fid).add(custList.get(1).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : Custmap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FTreeEntity_FEntryId"))&&Custmap.get(fid).get(0).equals(salesordermap.get("FSaleOrderId"))) {
                                    //如果对应的编码不为空
                                    if (null != Custmap.get(fid).get(1)) {
                                        salesordermap.put("CUST_ID", Custmap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("CUST_ID", "");
                                    }
                                }
                            }
                        }
                    }
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
