package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsCustomer;
import org.jeecg.modules.iost.ims.entity.ImsDept;
import org.jeecg.modules.iost.ims.kingdeeapi.DeptKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsDeptMapper;
import org.jeecg.modules.iost.ims.service.IImsDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims部门基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-13
 * @Version: V1.0
 */
@Service
public class ImsDeptServiceImpl extends ServiceImpl<ImsDeptMapper, ImsDept> implements IImsDeptService {
    @Autowired
    DeptKingdeeApi deptKingdeeApi;
    @Autowired
    ImsDeptMapper deptMapper;
    @Autowired
    IMSApi imsApi;
    /**
     * 同步金蝶云的部门信息
     * @param id,sysUser
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(String id, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsDept> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FDEPTID",id);
        //将对应信息请求金蝶云
        list=deptKingdeeApi.selectAndLog(idmap,null,"部门信息");
            //遍历集合拿到所有的MAP
            for (Map<String, String> data : list) {
                //判断是否有错误
                if(data.containsKey("false")){
                    return success;
                }
                //将实体信息记录下来
                ImsDept pojo = new ImsDept();
                pojo.setFid(data.get("fid"));
                pojo.setDisable(data.get("DISABLE"));
                pojo.setDeptId(data.get("DEPT_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setDeptName(data.get("DEPT_NAME"));
                pojo.setCreateTime(new Date());
                if(sysUser!=null){
                    pojo.setCreateBy(sysUser.getUsername());
                    pojo.setSysOrgCode(sysUser.getOrgCode());
                }
                pojolist.add(pojo);
            }
         //将数据信息 存放到数据库
        this.saveBatch(pojolist);
            //将数据包装成IMS格式
            Map<String,Object> map=new HashMap<>();
            map.put("success","true");
            map.put("message","操作成功");
            map.put("result", list);
            String mapjson = JsonUtil.Mapjson(map);
        String request=JsonUtil.Listjson(list);
            String body = ImsUtil.getIms("TB_SYS_DEPT",mapjson);
            //IMS同步
            String result = imsApi.add(body);
            //记录IMS日志
            Boolean flag = imsLogUtil.ImsLog(body,result, "部门信息","TB_SYS_DEPT");
            //设置同步成功状态
                success=flag;
//            success=true;
        return success;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = deptKingdeeApi.queryList(null, null, "部门信息分页查询", pageNo, pageSize);
        return list;
    }
}
