package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsWplan;
import org.jeecg.modules.iost.ims.entity.ImsWplanMnOuts;
import org.jeecg.modules.iost.ims.kingdeeapi.WplanMnOutsKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.WplanOutsKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWplanMnOutsMapper;
import org.jeecg.modules.iost.ims.service.IImsWplanMnOutsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims委外工单物料需求信息
 * @Author: jeecg-boot
 * @Date:   2021-09-29
 * @Version: V1.0
 */
@Service
public class ImsWplanMnOutsServiceImpl extends ServiceImpl<ImsWplanMnOutsMapper, ImsWplanMnOuts> implements IImsWplanMnOutsService {

    @Autowired
    WplanMnOutsKingdeeApi wplanMnOutsKingdeeApi;

    @Override
    public Map<String,Object> getData(List<Map<String,Object>> mapjson) throws ParseException {
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String, Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsWplanMnOuts> pojolist=new ArrayList<>();
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        //记录IMS日志
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(mapjson), "ERP委外用料清单信息","WPLAN_MN_OUTS");
        for(Map<String,Object> maps:mapjson){
            //获取委外用料订单编码
            String poId=maps.get("ERP_MO").toString();
            String erp_mo_seq = maps.get("ERP_MO_SEQ").toString();
            Map<String,String> idmap=new HashMap<>();
            //将对应的参数设置成金蝶云的查询条件
            idmap.put("FSubReqBillNO",poId);
            idmap.put("FSubReqEntrySeq",erp_mo_seq);
            //从金蝶云获取对应数据
            list1 = wplanMnOutsKingdeeApi.selectAndLog(idmap, null,"ERP委外用料清单信息");
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //将实体信息记录下来
                //判断是否有错误
                if(data.containsKey("false")){
                    map.put("false",data.get("false"));
                    return map;
                }
                ImsWplanMnOuts pojo = new ImsWplanMnOuts();
                pojo.setFid(data.get("fid"));
                pojo.setErpMo(data.get("ERP_MO"));
                pojo.setProdId(data.get("PROD_ID"));
                pojo.setPqty(data.get("P_QTY"));
                pojo.setMtrlId(data.get("MTRL_ID"));
                pojo.setIsMain(data.get("IS_MAIN"));
                pojo.setMainId(data.get("MAIN_ID"));
                pojo.setDosage(data.get("DOSAGE"));
                pojo.setNnQty(data.get("NN_QTY"));
                pojo.setTnQty(data.get("TN_QTY"));
                pojo.setPointStr(data.get("POINT_STR"));
                pojo.setSeq(data.get("SEQ"));
                pojo.setSeqEntryCode(data.get("SEQ_ENTRY_CODE"));
                pojo.setErpMoSeq(data.get("ERP_MO_SEQ"));
                pojo.setCreateTime(new Date());
                pojolist.add(pojo);
            }
        }

        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
//        //将查询结果封装成JSON
//        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }

}

