package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsAudit;
import org.jeecg.modules.iost.ims.service.IImsAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: ims其他出库单
 * @Author: jeecg-boot
 * @Date:   2021-09-06
 * @Version: V1.0
 */
@Api(tags="其他出库单信息")
@RestController
@RequestMapping("/imsAudit")
@Slf4j
public class ImsAuditController extends JeecgController<ImsAudit, IImsAuditService> {
    @Autowired
    IImsAuditService iImsAuditService;
    /**
     * 分页列表查询
     *
     * @param imsAudit
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims客户信息-分页列表查询")
    @ApiOperation(value="ims客户信息-分页列表查询", notes="ims客户信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsAudit imsAudit,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req,String date) {
        QueryWrapper<ImsAudit> queryWrapper = QueryGenerator.initQueryWrapper(imsAudit, req.getParameterMap()).orderByDesc("create_time");
        Page<ImsAudit> page = new Page<ImsAudit>(pageNo, pageSize);
        if(!"null".equals(date)){
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE,1);
            String parse1=sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time",parse);
            queryWrapper.lt("create_time",parse1);
        }
        IPage<ImsAudit> pageList = iImsAuditService.page(page, queryWrapper);
        return Result.OK(pageList);
    }




    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "IMS客户信息API-同步")
    @ApiOperation(value = "IMS客户信息API-同步", notes = "IMS客户信息API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag=iImsAuditService.synchronization(id,sysUser);
        if(flag){
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
