package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.modules.iost.ims.entity.ImsTkwbg;
import org.jeecg.modules.iost.ims.service.IImsTkwbgService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

/**
 * @Description: ims工时汇报
 * @Author: jeecg-boot
 * @Date:   2021-09-13
 * @Version: V1.0
 */
@Api(tags="工时汇报")
@RestController
@RequestMapping("/imsTkwbg")
@Slf4j
public class ImsTkwbgController extends JeecgController<ImsTkwbg, IImsTkwbgService> {
    @Autowired
    private IImsTkwbgService iImsTkwbgService;

    /**
     * 分页列表查询
     *
     * @param ImsTkwbg
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims工时汇报-分页列表查询")
    @ApiOperation(value="ims工时汇报-分页列表查询", notes="ims工时汇报-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsTkwbg ImsTkwbg,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req,String date) {
        QueryWrapper<ImsTkwbg> queryWrapper = QueryGenerator.initQueryWrapper(ImsTkwbg, req.getParameterMap());
        queryWrapper.orderByDesc("create_time");
        if(!"null".equals(date)){
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE,1);
            String parse1=sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time",parse);
            queryWrapper.lt("create_time",parse1);
        }
        Page<ImsTkwbg> page = new Page<ImsTkwbg>(pageNo, pageSize);
        IPage<ImsTkwbg> pageList = iImsTkwbgService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

}
