package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims_other_outstock
 * @Author: jeecg-boot
 * @Date:   2021-10-07
 * @Version: V1.0
 */
@Data
@TableName("ims_other_outstock")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_other_outstock对象", description="ims_other_outstock")
public class ImsOtherOutstock implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**唯一序号*/
	@Excel(name = "唯一序号", width = 15)
    @ApiModelProperty(value = "唯一序号")
    private java.lang.Integer queueId;
	/**交易时间*/
	@Excel(name = "交易时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "交易时间")
    private java.util.Date trxDate;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeId;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private java.math.BigDecimal quantity;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**库存组织*/
	@Excel(name = "库存组织", width = 15)
    @ApiModelProperty(value = "库存组织")
    private java.lang.String orgId;
	/**研发项目编码  --IMS增加项目维护 */
	@Excel(name = "研发项目编码  --IMS增加项目维护 ", width = 15)
    @ApiModelProperty(value = "研发项目编码  --IMS增加项目维护 ")
    private java.lang.String itemId;
    /**领料人  --IMS增加领料人  -- */
    @Excel(name = "领料人  --  --IMS增加领料人 ", width = 15)
    @ApiModelProperty(value = "领料人  --IMS增加领料人 ")
    private java.lang.String needUser;
	/**部门编码*/
	@Excel(name = "部门编码", width = 15)
    @ApiModelProperty(value = "部门编码")
    private java.lang.String deptId;
	/**货主类型 （1 业务组织 2供应商 3客户）*/
	@Excel(name = "货主类型 （1 业务组织 2供应商 3客户）", width = 15)
    @ApiModelProperty(value = "货主类型 （1 业务组织 2供应商 3客户）")
    private java.lang.String shipperType;
	/**货主编码*/
	@Excel(name = "货主编码", width = 15)
    @ApiModelProperty(value = "货主编码")
    private java.lang.String shipperId;
    /**单据编号(金蝶里面单据类型)*/
    @Excel(name = "单据编号(金蝶里面单据类型)", width = 15)
    @ApiModelProperty(value = "单据编号(金蝶里面单据类型)")
    private java.lang.String erpTrxCode;
	/**FID*/
	@Excel(name = "FID", width = 15)
    @ApiModelProperty(value = "FID")
    private java.lang.String fid;
	/**单据编号*/
	@Excel(name = "单据编号", width = 15)
    @ApiModelProperty(value = "单据编号")
    private java.lang.String fbillNo;
	/**FEntryID*/
	@Excel(name = "FEntryID", width = 15)
    @ApiModelProperty(value = "FEntryID")
    private java.lang.String fentryId;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
}
