package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

/**
 * 查询金蝶云ERP工单物料需求信息
 */
@Component
@Slf4j
public class WplanMnKingdeeApi implements web_api {
    @Autowired
    WplanMnKingdeeApi wplanMnKingdeeApi;
    /**
     * 操作的单据体名称
     */
    private String sFormId = "PRD_PPBOM";//生产用料清单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public WplanMnKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FMOBillNO", "FMOBillNO");//生产订单编号
        key.put("FMaterialID.FNumber", "FMaterialID.FNumber");//产品编码
        key.put("FQty", "FQty");//数量
        key.put("FMaterialID2.FNumber", "FMaterialID2.FNumber");//子项物料编码
        key.put("FMaterialType", "FMaterialType");//替代主料
        key.put("FStdQty", "FStdQty");//标准用量
        key.put("FMustQty", "FMustQty");//应发数量
        key.put("FNeedQty2", "FNeedQty2");//需求数量
        key.put("FPositionNO", "FPositionNO");//位置号
        key.put("FMOEntrySeq", "FMOEntrySeq");//生产订单行号
        key.put("FParentRowId", "FParentRowId");//父级行主键
        key.put("FEntity_FSeq", "FEntity_FSeq");//明细序号
        key.put("FEntity_FEntryID", "FEntity_FEntryID");//行内码
        key.put("FNumerator", "FNumerator");//分子
        key.put("FDenominator", "FDenominator");//分母
    }

    @CacheEvict(value = "Materid", allEntries = true)
    public void delMaterr() {
        System.out.println("清除缓存");
    }

    @CacheEvict(value = "Groupid", allEntries = true)
    public void delgroup() {
        System.out.println("清除缓存");
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /**
     * 查询父级的子项物料编码
     *
     * @param id
     * @return
     */
//    @Cacheable(cacheNames = "Materid", key = "#id")
    public List<List<Object>> getMaterid(String id) {
//        System.out.println("调用了getMaterid缓存第一次");
        List<List<Object>> lists = categoryDao.selectByIds("PRD_PPBOM", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMaterialID2.FNumber", "FMaterialID2.FNumber");
            put("FROWID","FROWID");
        }}, new HashMap<String, String>() {{
            put("FROWID", id);
        }});
        if(lists.isEmpty()||("").equals(lists.get(0).get(0).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }


    /**
     * 查询物料分组
     *
     * @param id
     * @return
     */
//    @Cacheable(cacheNames = "Groupid", key = "#id")
    public List<List<Object>> getGroupid(String id) {
//        System.out.println("调用了Groupid缓存第一次");
        List<List<Object>> lists = categoryDao.selectByIds("BD_MATERIAL", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMaterialGroup", "FMaterialGroup");
            put("FNumber","FNumber");
        }}, new HashMap<String, String>() {{
            put("FNumber", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"".equals(lists.get(0).get(0).toString())||"0".equals(lists.get(0).get(0).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }


    /**
     * 查询所有的物料分组
     *
     * @param
     * @return
     */
    public List<List<Object>> getALLParentid() {
        List<List<Object>> lists = categoryDao.select("SAL_MATERIALGROUP", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("Fnumber", "Fnumber");
            put("FPARENTID", "FPARENTID");
            put("Fid", "Fid");
        }}, null);
        return lists;
    }

    /**
     * 获取金蝶云数据
     *
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where, String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key, map, name);
        return WplanMn(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> WplanMn(List<List<Object>> list) {
        ExecutorService newExecutorService = Executors.newCachedThreadPool();
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                //遍历所有的物料分组
                List<List<Object>> allParentid = getALLParentid();
                Map<String, List> parentMap = new HashMap<>();
                for (List<Object> parent : allParentid) {
                    List panretList = new ArrayList();
                    //编码
                    panretList.add(parent.get(1).toString());
                    //父级
                    panretList.add(parent.get(2).toString());
                    parentMap.put(parent.get(0).toString(), panretList);
                }
                Map<String, List<String>> Groupmap = new HashMap<>();
                String Group = "";
                //添加主键与外键映射关系
                Map<String, List<String>> Matermap = new HashMap<>();
                String mater = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("WPLAN_MO", list1.get(1).toString());
                    salesordermap.put("PROD_ID", list1.get(2).toString());
                    salesordermap.put("P_QTY", list1.get(3).toString());
                    if(list1.get(4)==null||"".equals(list1.get(4).toString())){
                        salesordermap.put("MTRL_ID","");
                        salesordermap.put("MTRL_GROUP","");
                    }else {
                        salesordermap.put("MTRL_ID", list1.get(4).toString());
                        //将行内码和编码存入集合
                        List<String> idList = new ArrayList<>();
                        //编码
                        idList.add(list1.get(4).toString());
                        //行内码
                        Groupmap.put(list1.get(13).toString(), idList);
                        //拼接id做批量查询
                        Group = "'"+list1.get(4).toString() + "'," + Group;
//                        List groupid = wplanMnKingdeeApi.getGroupid(list1.get(4).toString());
//                        if(null==groupid||"".equals(groupid.toString())){
//                            salesordermap.put("MTRL_GROUP","");
//                        }else {
//                            String fid=groupid.get(0).toString();
//                            String number=groupid.get(1).toString();
//                            String parentid="";
//                            String parentnumber="";
//                            while (true){
//                                for (String key: parentMap.keySet()){
//                                    if(fid.equals(key)){
//                                        //将父级ID赋值
//                                        parentid=parentMap.get(key).get(1).toString();
//                                        parentnumber=parentMap.get(key).get(0).toString();
//                                        break;
//                                    }
//                                }
//                                //当父级为0是跳出循环
//                                if("0".equals(parentid)){
//                                    number=parentnumber;
//                                    break;
//                                }else {
//                                    //否则将父级ID赋值继续循环
//                                    fid=parentid;
//                                    number=parentnumber;
//                                }
//                            }
//                            salesordermap.put("MTRL_GROUP",number);
//                        }
                    }
                    if(list1.get(5)==null||"".equals(list1.get(5).toString())){
                        salesordermap.put("IS_MAIN","N");
                    }else {
                        if("1".equals(list1.get(5).toString())){
                            salesordermap.put("IS_MAIN", "Y");
                        }else {
                            salesordermap.put("IS_MAIN", "N");
                        }
                    }
                    Double FNumerator  = Double.valueOf(list1.get(14).toString());
                    Double FDenominator  = Double.valueOf(list1.get(15).toString());
                    double v = FNumerator / FDenominator;
                    salesordermap.put("DOSAGE", Double.toString(v));
                    salesordermap.put("NN_QTY", list1.get(7).toString());
                    salesordermap.put("TN_QTY", list1.get(8).toString());
                    if(list1.get(9)==null||"".equals(list1.get(9).toString())){
                        salesordermap.put("POINT_STR","");
                    }else {
                        salesordermap.put("POINT_STR", list1.get(9).toString());
                    }
                    salesordermap.put("ERP_MO_SEQ", list1.get(10).toString());
                    //判断是否是主料
                    if (list1.get(5)==null||"".equals(list1.get(5).toString())||"3".equals(list1.get(5).toString())) {
                        if(!"".equals(list1.get(11))&&list1.get(11)!=null){
                            //将行内码和编码存入集合
                            List<String> idList = new ArrayList<>();
                            //编码
                            idList.add(list1.get(11).toString());
                            //行内码
                            Matermap.put(list1.get(13).toString(), idList);
                            //拼接id做批量查询
                            mater = "'"+list1.get(11).toString() + "'," + mater;
                            salesordermap.put("FParentRowId",list1.get(11).toString());
//                            Object materid = wplanMnKingdeeApi.getMaterid(list1.get(11).toString());
//                            salesordermap.put("MAIN_ID",materid.toString());
                        }else {
                            if(list1.get(4)==null||"".equals(list1.get(4).toString())) {
                                salesordermap.put("MAIN_ID", "");
                            }else{
                                salesordermap.put("MAIN_ID",list1.get(4).toString());
                            }
                        }
                    } else {
                        if(list1.get(4)==null||"".equals(list1.get(4).toString())) {
                            salesordermap.put("MAIN_ID","");
                        }else{
                            salesordermap.put("MAIN_ID",list1.get(4).toString());
                        }
                    }
                    salesordermap.put("SEQ", list1.get(12).toString());
                    salesordermap.put("SEQ_ENTRY_CODE", list1.get(13).toString());
                    salesorderlist.add(salesordermap);
                }

                //添加各自的父级编码
                if(!"".equals(mater)){
                    //批量查出所有生产用料清单的数据
                    mater=mater.substring(0,mater.length()-1);
                    List<List<Object>> materid = getMaterid(mater);
                    if (null == materid || "".equals(materid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("MAIN_ID", "");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : Matermap.keySet()) {
                            for(List materList: materid){
                                //如果对应的行内码相同
                                if (Matermap.get(fid).get(0).equals(materList.get(0).toString())) {
                                    //将信息添加到集合
                                    Matermap.get(fid).add(materList.get(1).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : Matermap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("SEQ_ENTRY_CODE"))&&Matermap.get(fid).get(0).equals(salesordermap.get("FParentRowId"))) {
                                    //如果对应的编码不为空
                                    if (null != Matermap.get(fid).get(1)) {
                                        salesordermap.put("MAIN_ID", Matermap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("MAIN_ID", "");
                                    }
                                }
                            }
                        }
                    }
                }

                //添加各自的分组编码
                if(!"".equals(Group)){
                    //批量查出所有生产用料清单的数据
                    Group=Group.substring(0,Group.length()-1);
                    List<List<Object>> groupid = getGroupid(Group);
                    if (null == groupid || "".equals(groupid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("MTRL_GROUP", "");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : Groupmap.keySet()) {
                            for(List groupList: groupid){
                                //如果对应的行内码相同
                                if (Groupmap.get(fid).get(0).equals(groupList.get(1).toString())) {
                                    //将信息添加到集合
                                    Groupmap.get(fid).add(groupList.get(0).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : Groupmap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("SEQ_ENTRY_CODE"))&&Groupmap.get(fid).get(0).equals(salesordermap.get("MTRL_ID"))) {
                                    //如果对应的编码不为空
                                    if (null != Groupmap.get(fid).get(1)) {
                                        salesordermap.put("groupid", Groupmap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("groupid", "");
                                    }
                                }
                            }
                        }
                    }
                }

                //再次遍历集合将对应的分组编码找到最顶级的分组编码
                for (Map<String, String> salesordermap : salesorderlist) {
                    //如果集合中没有分组ID或者分组ID为空就将分组设置为空
                    if (!salesordermap.containsKey("groupid")||"".equals(salesordermap.get("groupid"))){
                        if(!salesordermap.containsKey("MTRL_GROUP")){
                            salesordermap.put("MTRL_GROUP","");
                        }
                    }else {
                        String fid= salesordermap.get("groupid");
                        String number="";
                        String parentid="";
                        String parentnumber="";
                        while (true){
                            for (String key: parentMap.keySet()){
                                if(fid.equals(key)){
                                    //将父级ID赋值
                                    parentid=parentMap.get(key).get(1).toString();
                                    parentnumber=parentMap.get(key).get(0).toString();
                                    break;
                                }
                            }
                            //当父级为0是跳出循环
                            if("0".equals(parentid)){
                                number=parentnumber;
                                break;
                            }else {
                                //否则将父级ID赋值继续循环
                                fid=parentid;
                                number=parentnumber;
                            }
                        }
                        salesordermap.put("MTRL_GROUP",number);
                    }
                }
            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
//        wplanMnKingdeeApi.delgroup();
//        wplanMnKingdeeApi.delMaterr();
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
