package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import org.jeecg.common.exception.DataRepeatException;
import org.jeecg.common.exception.KingdeeSelectException;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsOtherGodownentry;
import org.jeecg.modules.iost.ims.kingdeeapi.OtherKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsOtherGodownentryMapper;
import org.jeecg.modules.iost.ims.service.IImsOtherGodownentryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: ims其他入库单
 * @Author: jeecg-boot
 * @Date:   2021-10-08
 * @Version: V1.0
 */
@Service
public class ImsOtherGodownentryServiceImpl extends ServiceImpl<ImsOtherGodownentryMapper, ImsOtherGodownentry> implements IImsOtherGodownentryService {

    @Autowired
    OtherKingdeeApi otherKingdeeApi;
    private String imsLogName;
    private String DocType;

    public ImsOtherGodownentryServiceImpl() {
        this.imsLogName = "其他收料";  //ims日志-name
        this.DocType = "R175C";  //调用者传入的标识
    }

    public String setData(List<Map<String, Object>> lists,String code) {
        String FBillNo="";
        String message ="";
        String s1="";
        List<String> ids=new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(lists), imsLogName, DocType);
        //先根据唯一序号是否在数据库中存在，存在就返回错误信息，不存在就进行修改
        //遍历传入的集合信息
        for (Map<String, Object> maps : lists) {
            ids.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsOtherGodownentry> qw=new QueryWrapper();
        qw.in("queue_id",ids);
        StringBuilder builder=new StringBuilder();
        int length=ids.size();
        for (int i=0;i<length;i++) {
            if(i==0) {
                builder.append(ids.get(i));
            }
            else {
                builder.append(",").append(ids.get(i));
            }
        }
        qw.orderByAsc("FIELD(queue_id,"+builder.toString()+")");
        List<ImsOtherGodownentry> repeatLists = this.getBaseMapper().selectList(qw);
        //筛选出重复的单据
        if (!repeatLists.isEmpty()) {
            for (String s : ids) {
                s1=s+",";
            }
            s1=s1.substring(0,s1.length() -1);
            message= message+"唯一序号为 ：" + s1 + "的数据已经提交过!    ";
            throw new DataRepeatException("操作失败", message, code);
        }

        //将数据添加到金蝶云
        List<Map<String, String>> result =otherKingdeeApi.addTwo(lists);
        //判断是否出现错误
        String Addresult=result.get(0).get("result");
        if(!ObjectUtils.isEmpty(Addresult))
        {
            message="添加失败!"+Addresult;
            throw new KingdeeSelectException("操作失败",message,code);
        }
        List<ImsOtherGodownentry> pojoList = new ArrayList<>();
        //获取返回结果
        for (Map<String, Object> maps : lists) {
            //Map传入参数大写字段转化为实体类字段
            maps.put("FID", result.get(0).get("FID"));
            maps.put("FBILL_NO", result.get(0).get("FBILL_NO"));
            //查询对应的行内码以及行号
            Map<String,String> idmap=new HashMap<>();
            String fbill_no = maps.get("FBILL_NO").toString();
            idmap.put("FBillNo",fbill_no);
            idmap.put("FID",maps.get("FID").toString());
            Map<String,String> getmap=new HashMap<>();
            getmap.put("FEntity_FEntryID","FEntity_FEntryID");
            getmap.put("FEntity_FSeq","FEntity_FSeq");
            List<List<Object>> select = otherKingdeeApi.select(getmap, idmap);
            FBillNo=fbill_no;
            //可能一个单据编号下有多行
            for (List<Object> list:select){
                maps.put("FEntry_ID",list.get(1).toString());
                maps.put("FSEQ",list.get(0).toString());
                //将数据添加到集合中
                Map<String, Object> map = MapUtils.mapsChange(maps);
                ImsOtherGodownentry pojo = JSON.parseObject(JSON.toJSONString(map), ImsOtherGodownentry.class);//map转为实体类对象
                pojoList.add(pojo);
            }
        }
        //传入的实体字段保存到实体表
        this.saveBatch(pojoList);
        return FBillNo;
    }
}
