package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.modules.iost.ims.Util.*;
import org.jeecg.modules.iost.ims.entity.ImsOtherOutstock;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsOtherOutstockApi;
import org.jeecg.modules.iost.ims.mapper.ImsOtherOutstockMapper;
import org.jeecg.modules.iost.ims.service.IImsOtherOutstockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.*;

import org.springframework.util.CollectionUtils;

/**
 * @Description: ims_other_outstock
 * @Author: jeecg-boot
 * @Date:   2021-10-07
 * @Version: V1.0
 */
@Service
public class ImsOtherOutstockServiceImpl extends ServiceImpl<ImsOtherOutstockMapper, ImsOtherOutstock> implements IImsOtherOutstockService {
    @Autowired
    ImsOtherOutstockApi imsOtherOutstockApi;
    private String imsLogName;
    private String DocType;

    public ImsOtherOutstockServiceImpl() {
        this.imsLogName = "其它出库";  //ims日志-name
        this.DocType = "R100";  //调用者传入的标识
    }

    public String synchronization(List<Map<String,Object>> needLists,String code) {
        List<ImsOtherOutstock> ImsOtherOutstocks=new ArrayList<>();
        //唯一序号重复的返回结果Lists
        List<Map<String,Object>> queue_idRepeatResultLists=new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult=new ArrayList<>();
        //添加返回结果Lists
        List<String> addResultLists=new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsOtherOutstock> qw=new QueryWrapper();
        qw.in("queue_id",qidList);
        StringBuilder builder=new StringBuilder();
        int length=qidList.size();
        for (int i=0;i<length;i++) {
            if(i==0)
            {
                builder.append(qidList.get(i));
            }
            else
            {
                builder.append(",").append(qidList.get(i));
            }
        }
        qw.orderByAsc("FIELD(queue_id,"+builder.toString()+")");
        List<ImsOtherOutstock> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult=ResultSplitOne(repeatLists);
        }
        if(!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0),code);
        }
        Result result = imsOtherOutstockApi.addReturnResult(needLists);
        if(result.getResponseStatus().getIsSuccess())
        {
            for (Map<String, Object> needmap : needLists) {
                needmap.put("FBILL_NO",result.getNumber());
                needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                //Map传入参数大写字段转化为实体类字段
                Map<String, Object> map = MapUtils.mapsChange(needmap);
                ImsOtherOutstock ImsOtherOutstock = JSON.parseObject(JSON.toJSONString(map), ImsOtherOutstock.class);//map转为实体类对象
                ImsOtherOutstocks.add(ImsOtherOutstock);
            }
        }
        addResultLists= ResultSplitFour(result);
        if(!CollectionUtils.isEmpty(addResultLists)) {
            throw new kingdeeException("操作失败!修改失败!", addResultLists,code); }

        //保存实体类
        this.saveBatch(ImsOtherOutstocks);
        return ImsOtherOutstocks.get(0).getFbillNo();
    }

    public List<String> ResultSplitOne(List<ImsOtherOutstock> repeatLists)
    {
        String result=new String();
        LinkedHashSet<String> hashset=new LinkedHashSet<>();
        for (ImsOtherOutstock ImsOtherOutstock : repeatLists) {
            String queue_id = String.valueOf(ImsOtherOutstock.getQueueId());
            result="QUEUE_ID为("+queue_id+")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList=new ArrayList<>();
        String result2=new String();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }
    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult)
    {
        String result=new String();
        List<String> rustList=new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if(!isSuccess)
        {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }
}
