package org.jeecg.modules.iost.ims.Util;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.entity.Imslog;
import org.jeecg.modules.iost.ims.service.IImslogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * IMS日志工具
 */
@Component
public class ImsLogUtil {
    @Autowired
    IImslogService iImslogService;

    //单例模式
    private static ImsLogUtil uploadRooms;
    //服务器加载Servlet的时候运行，并且只会被服务器执行一次。PostConstruct在构造函数之后执行，init（）方法之前执行。
    @PostConstruct
    public void init() {
        uploadRooms = this;
        uploadRooms.iImslogService = this.iImslogService;
    }
    //添加IMS响应日志
    public  Boolean ImsLog(String request,String result,String name,String code){
        Imslog imslog=new Imslog();
        Boolean flag=false;
        //将返回结果转成JSON
        String s = XmlUtil.xmltoJson(result);
        //逐步拆分出对应的信息
        Map maps = (Map) JSON.parse(s);
        Object o = maps.get("SOAP-ENV:Body");
        Map map1 = (Map)JSON.parse(o.toString());
        Object o1 = map1.get("NS1:updateIMSDataResponse");
        Map map2 = (Map)JSON.parse(o1.toString());
        Object msg = map2.get("ResultMsg");
        Map map3 = (Map)JSON.parse(msg.toString());
        Object aReturn = map2.get("return");
        Map map4 = (Map)JSON.parse(aReturn.toString());
        Object message = map3.get("#text");
        Object success = map4.get("#text");

        //设置日志信息
        imslog.setName(name);
        imslog.setRequest(request);
        imslog.setMessage(message.toString());
        imslog.setResponse(s);
        imslog.setCreateTime(new Date());
        imslog.setCode(code);
        if (success.toString().equals("true")){
            flag=true;
            imslog.setSuccess("true");
        }else {
            imslog.setSuccess("false");
        }
        ImsLogUtil.uploadRooms.iImslogService.save(imslog);
        return flag;
    }

    /**
     * 设置IMS请求日志
     * @param data
     * @param name
     */
    public void ImsRequestLog(String data,String name,String code){
        Imslog imslog=new Imslog();
        imslog.setCode(code);
        imslog.setName(name);
        imslog.setSuccess("true");
        imslog.setResponse(data);
        imslog.setCreateTime(new Date());
        ImsLogUtil.uploadRooms.iImslogService.save(imslog);
    }
}
