package org.jeecg.modules.iost.ims.Util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 把不同的数据类型转化成json类型字符串
 */
public class JsonUtil {
    public static String Objectjson(Object obj) {
        StringBuilder json = new StringBuilder();  
        if (obj == null) {  
            json.append("\"\"");  
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Float  
             || obj instanceof Boolean || obj instanceof Short || obj instanceof Double  
             || obj instanceof Long || obj instanceof BigDecimal || obj instanceof BigInteger  
             || obj instanceof Byte) {  
            json.append("\"").append(Stringjson(obj.toString())).append("\"");
        } else if (obj instanceof Object[]) {  
            json.append(array2json((Object[]) obj));  
        } else if (obj instanceof List) {  
            json.append(Listjson((List<?>) obj));  
        } else if (obj instanceof Map) {  
            json.append(Mapjson((Map<?, ?>) obj));  
        } else if (obj instanceof Set) {  
            json.append(Setjson((Set<?>) obj));  
        } else {  
            json.append(bean2json(obj));  
        }  
        return json.toString();
    }
    
    public static String Stringjson(String s) {
        if (s == null)  
            return "";  
        StringBuilder sb = new StringBuilder();  
        for (int i = 0; i < s.length(); i++) {  
            char ch = s.charAt(i);  
            switch (ch) {  
                case '"':  
                    sb.append("\\\"");
                    break;
                case '\\':
                     sb.append("\\\\");
                     break;
                 case '\b':
                     sb.append("\\b");
                     break;
                 case '\f':
                     sb.append("\\f");
                     break;
                 case '\n':
                     sb.append("\\n");
                     break;
                 case '\r':
                     sb.append("\\r");
                     break;
                 case '\t':
                     sb.append("\\t");
                     break;
                 case '/':
                     sb.append("\\/");
                     break;
                 default:
                     if (ch >= '\u0000' && ch <= '\u001F') {
                         String ss = Integer.toHexString(ch);
                         sb.append("\\u");
                         for (int k = 0; k < 4 - ss.length(); k++) {
                             sb.append('0');
                         }
                         sb.append(ss.toUpperCase());
                     } else {
                         sb.append(ch);
                     }
            }
        }
        return sb.toString();
    }
    
    public static String array2json(Object[] array) {  
        StringBuilder json = new StringBuilder();  
        json.append("[");  
        if (array != null && array.length > 0) {  
            for (Object obj : array) {  
                json.append(Objectjson(obj));  
                json.append(",");  
            }
            json.setCharAt(json.length() - 1, ']');  
        } else {  
            json.append("]");  
        }  
        return json.toString();
    }
    
    public static String Listjson(List<?> list) {  
        StringBuilder json = new StringBuilder();  
        json.append("[");  
        if (list != null && list.size() > 0) {  
            for (Object obj : list) {  
                json.append(Objectjson(obj));  
                json.append(",");  
            }  
            json.setCharAt(json.length() - 1, ']');  
        } else {  
            json.append("]");  
        }  
        return json.toString();
    }
    
    public static String Mapjson(Map<?, ?> map) {  
        StringBuilder json = new StringBuilder();  
        json.append("{");  
        if (map != null && map.size() > 0) {  
            for (Object key : map.keySet()) {  
                json.append(Objectjson(key));  
                json.append(":");  
                json.append(Objectjson(map.get(key)));  
                json.append(",");  
            }  
            json.setCharAt(json.length() - 1, '}');  
        } else {  
            json.append("}");  
        }  
        return json.toString();  
    }
    
    public static String Setjson(Set<?> set) {  
        StringBuilder json = new StringBuilder();  
        json.append("[");  
        if (set != null && set.size() > 0) {  
            for (Object obj : set) {  
                json.append(Objectjson(obj));  
                json.append(",");  
            }  
            json.setCharAt(json.length() - 1, ']');  
        } else { 
            json.append("]");
        }  
        return json.toString();  
    }
    
    public static String bean2json(Object bean) {  
        StringBuilder json = new StringBuilder();  
        json.append("{");  
        PropertyDescriptor[] props = null;
        try {  
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();  
        } catch (IntrospectionException e) {}  
        if (props != null) {  
            for (int i = 0; i < props.length; i++) {  
                try {  
                    String name = Objectjson(props[i].getName());  
                    String value = Objectjson(props[i].getReadMethod().invoke(bean));  
                    json.append(name);  
                    json.append(":");  
                    json.append(value);  
                    json.append(",");  
                } catch (Exception e) {}  
            }  
            json.setCharAt(json.length() - 1, '}');  
         } else {  
             json.append("}");  
        }  
         return json.toString();  
    }
}