package org.jeecg.modules.iost.ims.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecgframework.codegenerate.generate.pojo.onetomany.SubTableVo;
import org.springframework.web.servlet.ModelAndView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * @Description: 自定义生成代码
 * @Author: jeecg-boot
 * @Date:   2021-09-06
 * @Version: V1.0
 */
@Api(tags="自定义生成代码")
@RestController
@RequestMapping("/autoGenerator")
@Slf4j
public class GeneratorController {
    @AutoLog(value = "自定义生成代码-自定义生成代码")
    @ApiOperation(value = "自定义生成代码-自定义生成代码", notes = "自定义生成代码-自定义生成代码")
    @GetMapping(value = "/autoCode")
    public Result GeneratorMybatisPlus() {
// 代码生成器
        AutoGenerator autoGenerator = new AutoGenerator();
        //默认为Velocity，这里设置为Freemarker引擎
        autoGenerator.setTemplateEngine(new FreemarkerTemplateEngine());
        // 全局配置
        GlobalConfig globalConfig = new GlobalConfig();
        //生成文件的输出目录
        String path = "/imssystem/storage";
        globalConfig.setOutputDir(path);
        // Author设置作者
        globalConfig.setAuthor("mybatis-plus");
        // 文件覆盖
        globalConfig.setFileOverride(true);
        // 生成后打开文件
        globalConfig.setOpen(false);
        // 自定义文件名风格，%s自动填充表实体属性
        globalConfig.setMapperName("%sMapper");
        globalConfig.setXmlName("%sMapper");
        globalConfig.setServiceName("%sService");
        globalConfig.setServiceImplName("%sServiceImpl");
        globalConfig.setEntityName("%s");
        globalConfig.setControllerName("%sController");
        autoGenerator.setGlobalConfig(globalConfig);

        //设置模板
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setEntity("templates/entity2.java");
        templateConfig.setController("templates/controller2.java");
        autoGenerator.setTemplate(templateConfig);
        ModelAndView mv = new ModelAndView();

        mv.addObject("rrrr", "10000");
        InjectionConfig injectionConfig = new InjectionConfig() {
            // 自定义属性注入，向自定义的模板中注入 my_field 属性
            // 通过 ${cfg.my_field} 获取属性之
            @Override
            public void initMap() {
                Map<String, Object> map = new HashMap<>();
                CategoryDao categoryDao = new CategoryDao();
                categoryDao.setDbId("777777");
                CategoryDao categoryDao2 = new CategoryDao();
                categoryDao2.setDbId("8888888");
                List<CategoryDao> lists = new ArrayList<>();
                lists.add(categoryDao);
                lists.add(categoryDao2);
                map.put("my_field", lists);//${cfg.my_field}
                this.setMap(map);
                SubTableVo s = new SubTableVo();

            }
        };
        autoGenerator.setCfg(injectionConfig);

        // 数据源配置
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDbType(DbType.MYSQL);
        dataSourceConfig.setTypeConvert(new MySqlTypeConvert());
        dataSourceConfig.setUrl("jdbc:mysql://192.168.2.65:3306/wmssystem?characterEncoding=UTF-8&useUnicode=true&useSSL=false&tinyInt1isBit=false&allowPublicKeyRetrieval=true&serverTimezone=Asia/Shanghai");
        dataSourceConfig.setDriverName("com.mysql.cj.jdbc.Driver");
        dataSourceConfig.setUsername("root");
        dataSourceConfig.setPassword("gf^*i6%&9J83&(*kJ653F&L");
        autoGenerator.setDataSource(dataSourceConfig);

        // 包名配置
        PackageConfig packageConfig = new PackageConfig();
        // 父包和子包名分开处理
        packageConfig.setParent("org.jeecg.modules.iost.ims");
        packageConfig.setController("controller");
        packageConfig.setEntity("entity");
        packageConfig.setMapper("mapper");
        packageConfig.setService("service");
        packageConfig.setServiceImpl("service.impl");
        autoGenerator.setPackageInfo(packageConfig);

        // 生成策略配置
        StrategyConfig strategy = new StrategyConfig();
        //设置命名格式
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        // 实体是否为lombok模型，默认 false
        strategy.setEntityLombokModel(true);
        //生成 @RestController 控制器
        strategy.setRestControllerStyle(true);
        // 驼峰转连字符
        strategy.setControllerMappingHyphenStyle(true);
        //表和前缀处理
        strategy.setInclude("dt_tess_pro".split(","));
        autoGenerator.setStrategy(strategy);
        // 执行，以上相关参数可以基于动态输入获取
        autoGenerator.execute();
        return Result.OK("代码生成成功");
    }
}

