package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: imsbom
 * @Author: jeecg-boot
 * @Date:   2021-10-04
 * @Version: V1.0
 */
@Data
@TableName("ims_bom")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_bom对象", description="imsbom")
public class ImsBom implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**成品编码*/
	@Excel(name = "成品编码", width = 15)
    @ApiModelProperty(value = "成品编码")
    private java.lang.String prodId;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
	/**是否主料*/
	@Excel(name = "是否主料", width = 15)
    @ApiModelProperty(value = "是否主料")
    private java.lang.String isMain;
	/**主料编码 （被替代）*/
	@Excel(name = "主料编码 （被替代）", width = 15)
    @ApiModelProperty(value = "主料编码 （被替代）")
    private java.lang.String mainId;
	/**用量*/
	@Excel(name = "用量", width = 15)
    @ApiModelProperty(value = "用量")
    private java.lang.String dosage;
	/**位置号 点位信息,多个用豆号分隔*/
	@Excel(name = "位置号 点位信息,多个用豆号分隔", width = 15)
    @ApiModelProperty(value = "位置号 点位信息,多个用豆号分隔")
    private java.lang.String pointStr;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
