/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.filter;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class GlobalAccessTokenFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(GlobalAccessTokenFilter.class);
    public static final String X_ACCESS_TOKEN = "X-Access-Token";

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String url = exchange.getRequest().getURI().getPath();
        log.info("  access url :  " + url);
        ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)exchange, (URI)exchange.getRequest().getURI());
        String rawPath = exchange.getRequest().getURI().getRawPath();
        String newPath = "/" + Arrays.stream(StringUtils.tokenizeToStringArray((String)rawPath, (String)"/")).skip(1L).collect(Collectors.joining("/"));
        ServerHttpRequest newRequest = exchange.getRequest().mutate().path(newPath).build();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, newRequest.getURI());
        ServerHttpRequest mutableReq = exchange.getRequest().mutate().header("Authorization-UserName", "").build();
        ServerWebExchange mutableExchange = exchange.mutate().request(mutableReq).build();
        return chain.filter(mutableExchange);
    }

    public int getOrder() {
        return 0;
    }
}

