package org.jeecg.modules.iost.API.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.API.entity.PhysicalidApi;
import org.jeecg.modules.iost.API.lanjieqi.Lanjieqi_API;
import org.jeecg.modules.iost.API.service.IPhysicalidApiService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.modules.iost.API.vo.Request;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 国网实物ID信息API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Api(tags="国网实物ID信息API")
@RestController
@RequestMapping("/API/entity-maintenance")
@Slf4j
public class PhysicalidApiController extends JeecgController<PhysicalidApi, IPhysicalidApiService> {
	@Autowired
	private IPhysicalidApiService physicalidApiService;
	
	/**
	 * 分页列表查询
	 *
	 * @param physicalidApi
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-分页列表查询")
	@ApiOperation(value="国网实物ID信息API-分页列表查询", notes="国网实物ID信息API-分页列表查询")
	@GetMapping(value = "/list")
	public Request<?> queryPageList(PhysicalidApi physicalidApi,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		String jieguo= Lanjieqi_API.Panduan(req);
		if (jieguo!=null){
			return Request.error10001(jieguo);
		}
		QueryWrapper<PhysicalidApi> queryWrapper = QueryGenerator.initQueryWrapper(physicalidApi, req.getParameterMap());
		Page<PhysicalidApi> page = new Page<PhysicalidApi>(pageNo, pageSize);
		IPage<PhysicalidApi> pageList = physicalidApiService.page(page, queryWrapper);
		return Request.OK(Lanjieqi_API.autowired(pageList));
	}
	
	/**
	 *   添加
	 *
	 * @param physicalidApi
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-添加")
	@ApiOperation(value="国网实物ID信息API-添加", notes="国网实物ID信息API-添加")
	@PostMapping(value = "/add")
	public Request<?> add(@RequestBody PhysicalidApi physicalidApi) {
		physicalidApiService.save(physicalidApi);

		return Request.OK(Lanjieqi_API.autowired(physicalidApi.getId()));
	}
	
	/**
	 *  编辑
	 *
	 * @param physicalidApi
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-编辑")
	@ApiOperation(value="国网实物ID信息API-编辑", notes="国网实物ID信息API-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody PhysicalidApi physicalidApi) {
		physicalidApiService.updateById(physicalidApi);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-通过id删除")
	@ApiOperation(value="国网实物ID信息API-通过id删除", notes="国网实物ID信息API-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		physicalidApiService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-批量删除")
	@ApiOperation(value="国网实物ID信息API-批量删除", notes="国网实物ID信息API-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.physicalidApiService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "国网实物ID信息API-通过id查询")
	@ApiOperation(value="国网实物ID信息API-通过id查询", notes="国网实物ID信息API-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		PhysicalidApi physicalidApi = physicalidApiService.getById(id);
		if(physicalidApi==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(physicalidApi);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param physicalidApi
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, PhysicalidApi physicalidApi) {
        return super.exportXls(request, physicalidApi, PhysicalidApi.class, "国网实物ID信息API");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PhysicalidApi.class);
    }

}
