package org.jeecg.modules.iost.API.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.modules.iost.API.entity.Purchaseorder;
import org.jeecg.modules.iost.API.lanjieqi.Lanjieqi_API;
import org.jeecg.modules.iost.API.service.IPurchaseorderService;
import org.jeecg.modules.iost.API.vo.Request;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

/**
 * @Description: 采购订单接口
 * @Author: jeecg-boot
 * @Date: 2021-07-09
 * @Version: V1.0
 */
@Api(tags = "采购订单接口")
@RestController
@RequestMapping("/API/supplier-send")
@Slf4j
public class PurchaseorderController extends JeecgController<Purchaseorder, IPurchaseorderService> {
    @Autowired
    private IPurchaseorderService purchaseorderService;
    @Autowired
    private Lanjieqi_API lanjieqi_api;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "采购订单接口-分页列表查询")
    @ApiOperation(value = "采购订单接口-分页列表查询", notes = "采购订单接口-分页列表查询")
    @GetMapping(value = "list")
    public Request<?> queryPageList(Purchaseorder purchaseorder,
                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                    HttpServletRequest req) {
        String jieguo = Lanjieqi_API.Panduan(req);
        if (jieguo != null) {
            return Request.error10001(jieguo);
        }
        QueryWrapper<Purchaseorder> queryWrapper = QueryGenerator.initQueryWrapper(purchaseorder, req.getParameterMap());
        Page<Purchaseorder> page = new Page<Purchaseorder>(pageNo, pageSize);
        IPage<Purchaseorder> pageList = purchaseorderService.page(page, queryWrapper);
        return Request.OK(Lanjieqi_API.autowired(pageList));
    }

    /**
     * 查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "采购订单接口-查询")
    @ApiOperation(value = "采购订单接口-查询", notes = "采购订单接口-查询")
    @GetMapping(value = "/select")
    public Request<?> select() {
        Map<String, Object> map = purchaseorderService.getMap(new QueryWrapper<Purchaseorder>().eq("id", "1414824544279822338"));
        if (map == null) {
            return Request.error("未找到对应数据");
        }
        return Request.OK(Lanjieqi_API.autowiredMap(map));
    }

    /**
     * 添加
     *
     * @param purchaseorder
     * @return
     */
    @AutoLog(value = "采购订单接口-添加")
    @ApiOperation(value = "采购订单接口-添加", notes = "采购订单接口-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody Purchaseorder purchaseorder) {
        purchaseorderService.save(purchaseorder);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param purchaseorder
     * @return
     */
    @AutoLog(value = "采购订单接口-编辑")
    @ApiOperation(value = "采购订单接口-编辑", notes = "采购订单接口-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody Purchaseorder purchaseorder) {
        purchaseorderService.updateById(purchaseorder);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "采购订单接口-通过id删除")
    @ApiOperation(value = "采购订单接口-通过id删除", notes = "采购订单接口-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        purchaseorderService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "采购订单接口-批量删除")
    @ApiOperation(value = "采购订单接口-批量删除", notes = "采购订单接口-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.purchaseorderService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "采购订单接口-通过id查询")
    @ApiOperation(value = "采购订单接口-通过id查询", notes = "采购订单接口-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        Purchaseorder purchaseorder = purchaseorderService.getById(id);
        if (purchaseorder == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(purchaseorder);
    }

    /**
     * 通过date查询
     *
     * @param
     * @return
     */
    @AutoLog(value = "采购订单接口-通过更新时间查询")
    @ApiOperation(value = "采购订单接口-通过更新时间查询", notes = "采购订单接口-通过更新时间查询")
    @PostMapping(value = "/queryByDate")
    public Request<?> queryByDate(@RequestBody Map dates) throws ParseException {
//		 QueryWrapper<Purchaseorder> locationReady = new QueryWrapper<Purchaseorder>()
//				 .ge("modifytime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2021-08-11 10:53:00"));;
        List<Purchaseorder> list = null;
        if (dates.containsKey("modifyStartTime")) {
            String date = (String) dates.get("modifyStartTime");
            QueryWrapper<Purchaseorder> locationReady = new QueryWrapper<Purchaseorder>()
                    .gt("modifytime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date))
                    .orderByDesc("modifytime");
            list = purchaseorderService.getBaseMapper().selectList(locationReady);
        }
        return Request.OK(Lanjieqi_API.autowiredList(list));
    }

    /**
     * 导出excel
     *
     * @param request
     * @param purchaseorder
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, Purchaseorder purchaseorder) {
        return super.exportXls(request, purchaseorder, Purchaseorder.class, "采购订单接口");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Purchaseorder.class);
    }

}
