package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网实物ID信息API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("physicalid_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="physicalid_api对象", description="国网实物ID信息API")
public class PhysicalidApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
	/**供应商名称*/
	@Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
	/**实物ID*/
	@Excel(name = "实物ID", width = 15)
    @ApiModelProperty(value = "实物ID")
    private String entitycode;
	/**采购订单行项目id*/
	@Excel(name = "采购订单行项目id", width = 15)
    @ApiModelProperty(value = "采购订单行项目id")
    private String poitemid;
	/**实物生产状态:0：未生产 1：生产中 2：生产完成*/
	@Excel(name = "实物生产状态:0：未生产 1：生产中 2：生产完成", width = 15)
    @ApiModelProperty(value = "实物生产状态:0：未生产 1：生产中 2：生产完成")
    private String entitystatus;
	/**数据来源:0：供应商， 1：网关， 2：代理*/
	@Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private String datasource;
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "来源数据创建时间")
    private Date datasourcecreatetime;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
	/**数据拥有方:取值：供应商编码*/
	@Excel(name = "数据拥有方:取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方:取值：供应商编码")
    private String ownerid;
	/**数据可见方:取值：采购方编码*/
	@Excel(name = "数据可见方:取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方:取值：采购方编码")
    private String openid;
}
