package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网产成品库存信息API
 * @Author: jeecg-boot
 * @Date:   2021-07-15
 * @Version: V1.0
 */
@Data
@TableName("productinventory_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="productinventory_api对象", description="国网产成品库存信息API")
public class ProductinventoryApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
	/**供应商名称*/
	@Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
	/**产成品编码*/
	@Excel(name = "产成品编码", width = 15)
    @ApiModelProperty(value = "产成品编码")
    private String productcode;
	/**产成品名称*/
	@Excel(name = "产成品名称", width = 15)
    @ApiModelProperty(value = "产成品名称")
    private String productname;
	/**产成品库存剩余数量*/
	@Excel(name = "产成品库存剩余数量", width = 15)
    @ApiModelProperty(value = "产成品库存剩余数量")
    private String productamount;
	/**计量单位*/
	@Excel(name = "计量单位", width = 15)
    @ApiModelProperty(value = "计量单位")
    private String productunit;
	/**数据来源:0：供应商， 1：网关， 2：代理*/
	@Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private String datasource;
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "来源数据创建时间")
    private Date datasourcecreatetime;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
	/**数据拥有方:取值：供应商编码*/
	@Excel(name = "数据拥有方:取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方:取值：供应商编码")
    private String ownerid;
	/**数据可见方:取值：采购方编码*/
	@Excel(name = "数据可见方:取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方:取值：采购方编码")
    private String openid;
}
