package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: production_scheduling_work_order
 * @Author: jeecg-boot
 * @Date:   2021-10-27
 * @Version: V1.0
 */
@Data
@TableName("production_scheduling_work_order")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="production_scheduling_work_order对象", description="production_scheduling_work_order")
public class ProductionSchedulingWorkOrder implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private String id;
	/**排产批次号*/
	@Excel(name = "排产批次号", width = 15)
    @ApiModelProperty(value = "排产批次号")
    private String batchcode;
	/**排产工单号*/
	@Excel(name = "排产工单号", width = 15)
    @ApiModelProperty(value = "排产工单号")
    private String schedulewo;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private String matcode;
	/**物料描述*/
	@Excel(name = "物料描述", width = 15)
    @ApiModelProperty(value = "物料描述")
    private String matdesc;
	/**排产数量*/
	@Excel(name = "排产数量", width = 15)
    @ApiModelProperty(value = "排产数量")
    private String scheduleamount;
	/**计量单位*/
	@Excel(name = "计量单位", width = 15)
    @ApiModelProperty(value = "计量单位")
    private String scheduleunit;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
	/**排产计划ID*/
	@Excel(name = "排产计划ID", width = 15)
    @ApiModelProperty(value = "排产计划ID")
    private String productionschedulingid;
}
