package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网生产订单API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("productionorder_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="productionorder_api对象", description="国网生产订单API")
public class ProductionorderApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
	/**订单类型:0：缺省值，可以无视；1：二次屏柜、2：二次装置*/
	@Excel(name = "订单类型:0：缺省值，可以无视；1：二次屏柜、2：二次装置", width = 15)
    @ApiModelProperty(value = "订单类型:0：缺省值，可以无视；1：二次屏柜、2：二次装置")
    private String ipotype;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
	/**供应商名称*/
	@Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
	/**生产订单号*/
	@Excel(name = "生产订单号", width = 15)
    @ApiModelProperty(value = "生产订单号")
    private String ipono;
	/**品类编码*/
	@Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
	/**种类编码*/
	@Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
	/**排产计划编码*/
	@Excel(name = "排产计划编码", width = 15)
    @ApiModelProperty(value = "排产计划编码")
    private String schedulecode;
	/**采购订单行项目id（供货单行项目id）或销售订单号*/
	@Excel(name = "采购订单行项目id（供货单行项目id）或销售订单号", width = 15)
    @ApiModelProperty(value = "采购订单行项目id（供货单行项目id）或销售订单号")
    private String poitemid;
	/**数据关联类型:默认为1； 1：关联采购订单行项目（供货单行项目）； 2：关联销售订单行项目*/
	@Excel(name = "数据关联类型:默认为1； 1：关联采购订单行项目（供货单行项目）； 2：关联销售订单行项目", width = 15)
    @ApiModelProperty(value = "数据关联类型:默认为1； 1：关联采购订单行项目（供货单行项目）； 2：关联销售订单行项目")
    private String datatype;
	/**销售订单行项目号*/
	@Excel(name = "销售订单行项目号", width = 15)
    @ApiModelProperty(value = "销售订单行项目号")
    private String soitemno;
	/**厂家物料编码*/
	@Excel(name = "厂家物料编码", width = 15)
    @ApiModelProperty(value = "厂家物料编码")
    private String materialscode;
	/**厂家物料名称*/
	@Excel(name = "厂家物料名称", width = 15)
    @ApiModelProperty(value = "厂家物料名称")
    private String materialsname;
	/**厂家物资单位*/
	@Excel(name = "厂家物资单位", width = 15)
    @ApiModelProperty(value = "厂家物资单位")
    private String materialsunit;
	/**厂家物料描述*/
	@Excel(name = "厂家物料描述", width = 15)
    @ApiModelProperty(value = "厂家物料描述")
    private String materialsdesc;
	/**生产数量*/
	@Excel(name = "生产数量", width = 15)
    @ApiModelProperty(value = "生产数量")
    private String amount;
	/**计量单位*/
	@Excel(name = "计量单位", width = 15)
    @ApiModelProperty(value = "计量单位")
    private String unit;
	/**物资id分组*/
	@Excel(name = "物资id分组", width = 15)
    @ApiModelProperty(value = "物资id分组")
    private String productidgrpno;
	/**物资id类型*/
	@Excel(name = "物资id类型", width = 15)
    @ApiModelProperty(value = "物资id类型")
    private String productidtype;
	/**产品型号*/
	@Excel(name = "产品型号", width = 15)
    @ApiModelProperty(value = "产品型号")
    private String productmodel;
	/**计划开始日期*/
	@Excel(name = "计划开始日期", width = 15)
    @ApiModelProperty(value = "计划开始日期")
    private String planstartdate;
	/**计划完成日期*/
	@Excel(name = "计划完成日期", width = 15)
    @ApiModelProperty(value = "计划完成日期")
    private String planfinishdate;
	/**实际开始日期*/
	@Excel(name = "实际开始日期", width = 15)
    @ApiModelProperty(value = "实际开始日期")
    private String actualstartdate;
	/**实际完成日期*/
	@Excel(name = "实际完成日期", width = 15)
    @ApiModelProperty(value = "实际完成日期")
    private String actualfinishdate;
	/**生产工厂名称*/
	@Excel(name = "生产工厂名称", width = 15)
    @ApiModelProperty(value = "生产工厂名称")
    private String plantname;
	/**生产车间名称*/
	@Excel(name = "生产车间名称", width = 15)
    @ApiModelProperty(value = "生产车间名称")
    private String workshopname;
	/**生产订单状态*/
	@Excel(name = "生产订单状态", width = 15)
    @ApiModelProperty(value = "生产订单状态")
    private String ipostatus;
	/**生产中心*/
	@Excel(name = "生产中心", width = 15)
    @ApiModelProperty(value = "生产中心")
    private String center;
	/**数据来源*/
	@Excel(name = "数据来源", width = 15)
    @ApiModelProperty(value = "数据来源")
    private String datasource;
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
	/**数据拥有方*/
	@Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
	/**数据可见方*/
	@Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;
}
