package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 采购订单接口
 * @Author: jeecg-boot
 * @Date:   2021-07-09
 * @Version: V1.0
 */
@Data
@TableName("purchaseorder")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="purchaseorder对象", description="采购订单接口")
public class Purchaseorder implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购订单编码*/
	@Excel(name = "采购订单编码", width = 15)
    @ApiModelProperty(value = "采购订单编码")
    private String pono;
	/**采购订单行项目号*/
	@Excel(name = "采购订单行项目号", width = 15)
    @ApiModelProperty(value = "采购订单行项目号")
    private String poitemno;
	/**采购订单行项目id*/
	@Excel(name = "采购订单行项目id", width = 15)
    @ApiModelProperty(value = "采购订单行项目id")
    private String poitemid;
	/**合同编号*/
	@Excel(name = "合同编号", width = 15)
    @ApiModelProperty(value = "合同编号")
    private String concode;
	/**合同名称*/
	@Excel(name = "合同名称", width = 15)
    @ApiModelProperty(value = "合同名称")
    private String conname;
	/**采购方公司名称*/
	@Excel(name = "采购方公司名称", width = 15)
    @ApiModelProperty(value = "采购方公司名称")
    private String buyername;
    /**采购方公司编码*/
    @Excel(name = "采购方公司编码", width = 15)
    @ApiModelProperty(value = "采购方公司编码")
    private String buyercode;
	/**采购方物料编码*/
	@Excel(name = "采购方物料编码", width = 15)
    @ApiModelProperty(value = "采购方物料编码")
    private String materialcode;
	/**采购方物料描述*/
	@Excel(name = "采购方物料描述", width = 15)
    @ApiModelProperty(value = "采购方物料描述")
    private String materialdesc;
	/**采购数量*/
	@Excel(name = "采购数量", width = 15)
    @ApiModelProperty(value = "采购数量")
    private String amount;
	/**合同编号（国网经法）*/
	@Excel(name = "合同编号（国网经法）", width = 15)
    @ApiModelProperty(value = "合同编号（国网经法）")
    private String sellerconcode;
	/**技术规范流水号*/
	@Excel(name = "技术规范流水号", width = 15)
    @ApiModelProperty(value = "技术规范流水号")
    private String serialnumber;
	/**合同签订日期*/
	@Excel(name = "合同签订日期", width = 15)
    @ApiModelProperty(value = "合同签订日期")
    private String sellersigntime;
	/**合同类型*/
	@Excel(name = "合同类型", width = 15)
    @ApiModelProperty(value = "合同类型")
    private Integer contype;
	/**项目编号*/
	@Excel(name = "项目编号", width = 15)
    @ApiModelProperty(value = "项目编号")
    private String prjcode;
	/**工程项目名称*/
	@Excel(name = "工程项目名称", width = 15)
    @ApiModelProperty(value = "工程项目名称")
    private String prjname;
	/**物资编码*/
	@Excel(name = "物资编码", width = 15)
    @ApiModelProperty(value = "物资编码")
    private String matcode;
	/**采购技术固化ID*/
	@Excel(name = "采购技术固化ID", width = 15)
    @ApiModelProperty(value = "采购技术固化ID")
    private String fixedtechid;
	/**合同包号*/
	@Excel(name = "合同包号", width = 15)
    @ApiModelProperty(value = "合同包号")
    private String pkgno;
	/**招标批次号*/
	@Excel(name = "招标批次号", width = 15)
    @ApiModelProperty(value = "招标批次号")
    private String bidbatcode;
	/**固化ID描述*/
	@Excel(name = "固化ID描述", width = 15)
    @ApiModelProperty(value = "固化ID描述")
    private String extdes;
	/**物资大类编码*/
	@Excel(name = "物资大类编码", width = 15)
    @ApiModelProperty(value = "物资大类编码")
    private String matmaxcode;
	/**物资中类编码*/
	@Excel(name = "物资中类编码", width = 15)
    @ApiModelProperty(value = "物资中类编码")
    private String matmedcode;
	/**物资小类编码*/
	@Excel(name = "物资小类编码", width = 15)
    @ApiModelProperty(value = "物资小类编码")
    private String matmincode;
	/**物资大类名称*/
	@Excel(name = "物资大类名称", width = 15)
    @ApiModelProperty(value = "物资大类名称")
    private String matmaxname;
	/**物资中类名称*/
	@Excel(name = "物资中类名称", width = 15)
    @ApiModelProperty(value = "物资中类名称")
    private String matmedname;
	/**物资小类名称*/
	@Excel(name = "物资小类名称", width = 15)
    @ApiModelProperty(value = "物资小类名称")
    private String matminname;
	/**更新时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@Excel(name = "更新时间", width = 15)
    @ApiModelProperty(value = "更新时间")
    private Date modifytime;
	/**每页条数*/
//	@Excel(name = "每页条数", width = 15)
//    @ApiModelProperty(value = "每页条数")
//    private int pagesize;
//	/**当前页码*/
//	@Excel(name = "当前页码", width = 15)
//    @ApiModelProperty(value = "当前页码")
//    private int pagenum;
//	/**页数*/
//	@Excel(name = "页数", width = 15)
//    @ApiModelProperty(value = "页数")
//    private int pagecount;
//	/**总记录数*/
//	@Excel(name = "总记录数", width = 15)
//    @ApiModelProperty(value = "总记录数")
//    private int total;
}
