package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网报工信息API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("reportwork")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="reportwork对象", description="国网报工信息API")
public class Reportwork implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private java.lang.String purchaserhqcode;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private java.lang.String suppliercode;
	/**生产订单编号*/
	@Excel(name = "生产订单编号", width = 15)
    @ApiModelProperty(value = "生产订单编号")
    private java.lang.String ipono;
	/**产品内部ID号*/
	@Excel(name = "产品内部ID号", width = 15)
    @ApiModelProperty(value = "产品内部ID号")
    private java.lang.String insideno;
	/**设备编号*/
	@Excel(name = "设备编号", width = 15)
    @ApiModelProperty(value = "设备编号")
    private java.lang.String deviceno;
	/**生产批次号*/
	@Excel(name = "生产批次号", width = 15)
    @ApiModelProperty(value = "生产批次号")
    private java.lang.String productbatchno;
	/**工序名称*/
	@Excel(name = "工序名称", width = 15)
    @ApiModelProperty(value = "工序名称")
    private java.lang.String processname;
	/**品类编码*/
	@Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private java.lang.String categorycode;
	/**种类编码*/
	@Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private java.lang.String subclasscode;
	/**工序编码*/
	@Excel(name = "工序编码", width = 15)
    @ApiModelProperty(value = "工序编码")
    private java.lang.String processcode;
	/**生产工艺路线编码*/
	@Excel(name = "生产工艺路线编码", width = 15)
    @ApiModelProperty(value = "生产工艺路线编码")
    private java.lang.String processno;
	/**生产车间id*/
	@Excel(name = "生产车间id", width = 15)
    @ApiModelProperty(value = "生产车间id")
    private java.lang.String workshopid;
	/**生产车间编码*/
	@Excel(name = "生产车间编码", width = 15)
    @ApiModelProperty(value = "生产车间编码")
    private java.lang.String workshopcode;
	/**生产车间名称*/
	@Excel(name = "生产车间名称", width = 15)
    @ApiModelProperty(value = "生产车间名称")
    private java.lang.String workshopname;
	/**生产工单编号*/
	@Excel(name = "生产工单编号", width = 15)
    @ApiModelProperty(value = "生产工单编号")
    private java.lang.String wono;
	/**实物id，如国网实物id*/
	@Excel(name = "实物id，如国网实物id", width = 15)
    @ApiModelProperty(value = "实物id，如国网实物id")
    private java.lang.String productid;
	/**数据来源:0：供应商， 1：网关， 2：代理*/
	@Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private java.lang.String datasource;
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "来源数据创建时间")
    private java.util.Date datasourcecreatetime;
	/**计划开始时间*/
	@Excel(name = "计划开始时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "计划开始时间")
    private java.util.Date planstarttime;
}
