package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网备品备件库存API
 * @Author: jeecg-boot
 * @Date:   2021-07-15
 * @Version: V1.0
 */
@Data
@TableName("reservestock_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="reservestock_api对象", description="国网备品备件库存API")
public class ReservestockApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
	/**供应商名称*/
	@Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
	/**备品备件编号*/
	@Excel(name = "备品备件编号", width = 15)
    @ApiModelProperty(value = "备品备件编号")
    private String spareproductcode;
	/**备品备件描述*/
	@Excel(name = "备品备件描述", width = 15)
    @ApiModelProperty(value = "备品备件描述")
    private String productdec;
	/**备品备件库存剩余数量*/
	@Excel(name = "备品备件库存剩余数量", width = 15)
    @ApiModelProperty(value = "备品备件库存剩余数量")
    private String productamount;
	/**计量单位*/
	@Excel(name = "计量单位", width = 15)
    @ApiModelProperty(value = "计量单位")
    private String productunit;
	/**数据来源*/
	@Excel(name = "数据来源", width = 15)
    @ApiModelProperty(value = "数据来源")
    private String datasource;
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
	/**数据拥有方*/
	@Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
	/**数据可见方*/
	@Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;
}
