package org.jeecg.modules.iost.API.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;
import java.util.List;

/**
 * @Description: 国网销售订单API
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("sales_order_api_heard")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "", description = "国网销售订单API")
public class SalesOrderApiHeard implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
//    @TableId(type = IdType.ASSIGN_ID)
    @TableId(type = IdType.ID_WORKER)
    @ApiModelProperty(value = "主键")
    private String id;
    //	"purchaserHqCode": "SGCC",
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;

    //	"soNo": "string",//add:必须推送数据;update:不可更新该字段
    @Excel(name = "销售订单号", width = 15)
    @ApiModelProperty(value = "销售订单号")
    private String sono;
    //	"supplierCode": "string",//add:必须推送数据;update:不可更新该字段
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    //	"buyerCode": "string",
    @Excel(name = "采购方公司编码", width = 15)
    @ApiModelProperty(value = "采购方公司编码")
    private String buyercode;
    //"buyerName": "string",
    @Excel(name = "采购方公司名称", width = 15)
    @ApiModelProperty(value = "采购方公司名称")
    private String buyername;
    //"buyerProvince": "string",
    @Excel(name = "采购方公司省份", width = 15)
    @ApiModelProperty(value = "采购方公司省份")
    private String buyerprovince;
    //	"categoryCode": "string",
    @Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
    //	"soStatus": 1,
    @Excel(name = "销售订单状态", width = 15)
    @ApiModelProperty(value = "销售订单状态")
    private Integer sostatus;
    //	"dataSource": "string",
    @Excel(name = "数据来源 0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源 0：供应商， 1：网关， 2：代理")
    private String datasource;
    //	"dataSourceCreateTime": "string",
    @Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
    //"ownerId": "string",
    @Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
    //"openId": "string",
    @Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;
    @TableField(exist = false)
    private List<SalesOrderApiItem> itemlist;
}
