package org.jeecg.modules.iost.API.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 国网销售订单API
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("sales_order_api_item")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "", description = "国网销售订单API")
public class SalesOrderApiItem implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

//"soItemNo": "string",
    /**
     * 销售订单行项目号
     */
    @Excel(name = "销售订单行项目号", width = 15)
    @ApiModelProperty(value = "销售订单行项目号")
    private String soitemno;
//		"categoryCode": "string",
    /**
     * 品类编码
     */
    @Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
//		"subclassCode": "string",
    /**
     * 种类编码
     */
    @Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
//"poItemId": "string",
    /**
     * 采购订单行项目ID
     */
    @Excel(name = "采购订单行项目ID", width = 15)
    @ApiModelProperty(value = "采购订单行项目ID")
    private String poitemid;
//		"productCode": "string",
    /**
     * 物资编码
     */
    @Excel(name = "物资编码", width = 15)
    @ApiModelProperty(value = "物资编码")
    private String productcode;
//		"productName": "string",
    /**
     * 物资名称
     */
    @Excel(name = "物资名称", width = 15)
    @ApiModelProperty(value = "物资名称")
    private String productname;
//		"productUnit": "string",
    /**
     * 物资单位
     */
    @Excel(name = "物资单位", width = 15)
    @ApiModelProperty(value = "物资单位")
    private String productunit;
//		"productAmount": "string",
    /**
     * 物资数量
     */
    @Excel(name = "物资数量", width = 15)
    @ApiModelProperty(value = "物资数量")
    private String productamount;
    //"ownerId": "string",
    @Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
    //"openId": "string",
    @Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;

    //"openId": "string",
    @Excel(name = "", width = 15)
    @ApiModelProperty(value = "")
    private String salesorderid;
}
