package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网销售订单API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("salesorder_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="salesorder_api对象", description="国网销售订单API")
public class SalesorderApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private java.lang.String purchaserhqcode;
	/**销售订单号*/
	@Excel(name = "销售订单号", width = 15)
    @ApiModelProperty(value = "销售订单号")
    private java.lang.String sono;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private java.lang.String suppliercode;
	/**采购方公司编码*/
	@Excel(name = "采购方公司编码", width = 15)
    @ApiModelProperty(value = "采购方公司编码")
    private java.lang.String buyercode;
	/**采购方公司名称*/
	@Excel(name = "采购方公司名称", width = 15)
    @ApiModelProperty(value = "采购方公司名称")
    private java.lang.String buyername;
	/**采购方公司省份*/
	@Excel(name = "采购方公司省份", width = 15)
    @ApiModelProperty(value = "采购方公司省份")
    private java.lang.String buyerprovince;
	/**品类编码*/
	@Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private java.lang.String categorycode;
	/**种类编码*/
	@Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private java.lang.String subclasscode;
	/**销售订单状态*/
	@Excel(name = "销售订单状态", width = 15)
    @ApiModelProperty(value = "销售订单状态")
    private java.lang.String sostatus;
	/**销售订单行项目号*/
	@Excel(name = "销售订单行项目号", width = 15)
    @ApiModelProperty(value = "销售订单行项目号")
    private java.lang.String soitemno;
	/**采购订单行项目ID*/
	@Excel(name = "采购订单行项目ID", width = 15)
    @ApiModelProperty(value = "采购订单行项目ID")
    private java.lang.String poitemid;
	/**物资编码*/
	@Excel(name = "物资编码", width = 15)
    @ApiModelProperty(value = "物资编码")
    private java.lang.String productcode;
	/**物资名称*/
	@Excel(name = "物资名称", width = 15)
    @ApiModelProperty(value = "物资名称")
    private java.lang.String productname;
	/**物资单位*/
	@Excel(name = "物资单位", width = 15)
    @ApiModelProperty(value = "物资单位")
    private java.lang.String productunit;
	/**物资数量*/
	@Excel(name = "物资数量", width = 15)
    @ApiModelProperty(value = "物资数量")
    private java.lang.String productamount;
	/**数据拥有方*/
	@Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private java.lang.String ownerid;
	/**数据可见方*/
	@Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private java.lang.String openid;
	/**数据来源 0：供应商， 1：网关， 2：代理*/
	@Excel(name = "数据来源 0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源 0：供应商， 1：网关， 2：代理")
    private java.lang.String datasource;
	/**来源数据创建时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
}
