package org.jeecg.modules.iost.API.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 国网工单Api
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("workorder_api")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="workorder_api对象", description="国网工单Api")
public class WorkorderApi implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**采购方总部编码*/
	@Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
	/**供应商生产订单编号*/
	@Excel(name = "供应商生产订单编号", width = 15)
    @ApiModelProperty(value = "供应商生产订单编号")
    private String ipono;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
	/**供应商名称*/
	@Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
	/**生产工单编码*/
	@Excel(name = "生产工单编码", width = 15)
    @ApiModelProperty(value = "生产工单编码")
    private String wono;
	/**品类编码*/
	@Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
	/**种类编码*/
	@Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
	/**厂家物料编码*/
	@Excel(name = "厂家物料编码", width = 15)
    @ApiModelProperty(value = "厂家物料编码")
    private String materialscode;
	/**厂家物料描述*/
	@Excel(name = "厂家物料描述", width = 15)
    @ApiModelProperty(value = "厂家物料描述")
    private String materialsdescription;
	/**物料批次*/
	@Excel(name = "物料批次", width = 15)
    @ApiModelProperty(value = "物料批次")
    private String materialsbatch;
	/**生产数量*/
	@Excel(name = "生产数量", width = 15)
    @ApiModelProperty(value = "生产数量")
    private String amount;
	/**计量单位*/
	@Excel(name = "计量单位", width = 15)
    @ApiModelProperty(value = "计量单位")
    private String unit;
	/**计划开始日期*/
	@Excel(name = "计划开始日期", width = 15)
    @ApiModelProperty(value = "计划开始日期")
    private String planstartdate;
	/**计划完成日期*/
	@Excel(name = "计划完成日期", width = 15)
    @ApiModelProperty(value = "计划完成日期")
    private String planfinishdate;
	/**实际开始日期*/
	@Excel(name = "实际开始日期", width = 15)
    @ApiModelProperty(value = "实际开始日期")
    private String actualstartdate;
	/**实际完成日期*/
	@Excel(name = "实际完成日期", width = 15)
    @ApiModelProperty(value = "实际完成日期")
    private String actualfinishdate;
	/**工单状态 :1：创建，2：原材料检验 3：生产中（包含原材料检验），:4：出厂试验，5：包装入库*/
	@Excel(name = "工单状态 :1：创建，2：原材料检验 3：生产中（包含原材料检验），:4：出厂试验，5：包装入库", width = 15)
    @ApiModelProperty(value = "工单状态 :1：创建，2：原材料检验 3：生产中（包含原材料检验），:4：出厂试验，5：包装入库")
    private String wostatus;
	/**实物ID*/
	@Excel(name = "实物ID", width = 15)
    @ApiModelProperty(value = "实物ID")
    private String entitycode;
	/**工艺路线编码*/
	@Excel(name = "工艺路线编码", width = 15)
    @ApiModelProperty(value = "工艺路线编码")
    private String processrouteno;
	/**数据来源:0：供应商， 1：网关， 2：代理*/
	@Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private String datasource;
	/**来源数据创建时间*/
	@Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
	/**数据拥有方:取值：供应商编码*/
	@Excel(name = "数据拥有方:取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方:取值：供应商编码")
    private String ownerid;
	/**数据可见方:取值：采购方编码*/
	@Excel(name = "数据可见方:取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方:取值：采购方编码")
    private String openid;
	/**产品型号规格*/
	@Excel(name = "产品型号规格", width = 15)
    @ApiModelProperty(value = "产品型号规格")
    private String modelspec;
}
