package org.jeecg.modules.iost.API.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.Getter;
import org.jeecg.modules.iost.API.entity.SalesOrderApiHeard;
import org.jeecg.modules.iost.API.entity.SalesOrderApiItem;
import org.jeecg.modules.iost.API.mapper.SalesOrderApiHeardMapper;
import org.jeecg.modules.iost.API.mapper.SalesOrderApiItemMapper;
import org.jeecg.modules.iost.API.service.ISalesOrderApiHeardService;


import org.jeecg.modules.iost.API.service.ISalesOrderApiItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.*;

/**
 * @Description: 国网销售订单API
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Service
public class SalesOrderApiHeardServiceImpl extends ServiceImpl<SalesOrderApiHeardMapper, SalesOrderApiHeard> implements ISalesOrderApiHeardService {
    @Autowired
    private SalesOrderApiHeardMapper heardMapper;
    @Autowired
    private SalesOrderApiItemMapper itemMapper;
    @Autowired
    private ISalesOrderApiItemService itemService;

    @Override
    public List<SalesOrderApiHeard> selectList(Wrapper<SalesOrderApiHeard> wrapper) {
        List<SalesOrderApiHeard> heardList = heardMapper.selectList(wrapper);
        for (SalesOrderApiHeard heard : heardList) {
            Map<String, Object> map = new HashMap<>();
            map.put("salesorderid", heard.getId());
            List<SalesOrderApiItem> listItem = itemMapper.selectByMap(map);
            heard.setItemlist(listItem);
        }
        return heardList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(SalesOrderApiHeard entity) {
        try {
            heardMapper.insert(entity);
            List<SalesOrderApiItem> itemlist = entity.getItemlist();
            List<SalesOrderApiItem> itemlist_dto = new ArrayList<>();
            for (SalesOrderApiItem item : itemlist) {
                itemlist_dto.add(item.setSalesorderid(entity.getId()));
            }
            itemService.saveBatch(itemlist_dto);
        } catch (Exception e) {
            System.out.println("error***************:" + e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean executeBatch(Collection<SalesOrderApiHeard> listEntity) {
        for (SalesOrderApiHeard entity : listEntity) {
            try {
                heardMapper.insert(entity);
                List<SalesOrderApiItem> itemlist = entity.getItemlist();
                List<SalesOrderApiItem> itemlist_dto = new ArrayList<>();
                for (SalesOrderApiItem item : itemlist) {
                    itemlist_dto.add(item.setSalesorderid(entity.getId()));
                }
                itemService.saveBatch(itemlist_dto);
            } catch (Exception e) {
                System.out.println("error***************:" + e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return false;
            }
        }

        return true;
    }
}
