package org.jeecg.modules.iost.API.servlets;

import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * 返回请求时增加响应头的属性
 */
@Component
@WebFilter(urlPatterns = "/API/")
public class LoginServlet extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String headerName = (String) enumeration.nextElement();
            String headValue = httpServletRequest.getHeader(headerName);
            if (headerName.equals("orisys")) {
                httpServletResponse.addHeader("orisys", headValue);
            }
            if (headerName.equals("transno")) {
                httpServletResponse.addHeader("transno", headValue);
            }
            if (headerName.equals("operatetype")) {
                httpServletResponse.addHeader("operatetype", headValue);
            }

        }
        filterChain.doFilter(httpServletRequest, httpServletResponse);
    }
}

