package org.jeecg.modules.iost.basedata.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecordPic;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheet;
import org.jeecg.modules.iost.basedata.entity.IostSummarySheetList;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordPicService;
import org.jeecg.modules.iost.basedata.service.IIostSummarySheetListService;
import org.jeecg.modules.iost.basedata.service.IIostSummarySheetService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 上传收费单
 * @Author: jeecg-boot
 * @Date:   2021-01-08
 * @Version: V1.0
 */
@Api(tags="上传收费单")
@RestController
@RequestMapping("/basedata/iostDeliveryRecordPic")
@Slf4j
public class IostDeliveryRecordPicController extends JeecgController<IostDeliveryRecordPic, IIostDeliveryRecordPicService> {
	@Autowired
	private IIostDeliveryRecordPicService iostDeliveryRecordPicService;
	@Autowired
	private IIostSummarySheetListService iostSummarySheetListService;
	@Autowired
	private IIostSummarySheetService iostSummarySheetService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostDeliveryRecordPic
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "上传收费单-分页列表查询")
	@ApiOperation(value="上传收费单-分页列表查询", notes="上传收费单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostDeliveryRecordPic iostDeliveryRecordPic,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostDeliveryRecordPic> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliveryRecordPic, req.getParameterMap());
		Page<IostDeliveryRecordPic> page = new Page<IostDeliveryRecordPic>(pageNo, pageSize);
		IPage<IostDeliveryRecordPic> pageList = iostDeliveryRecordPicService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostDeliveryRecordPic
	 * @return
	 */
	@AutoLog(value = "上传收费单-添加")
	@ApiOperation(value="上传收费单-添加", notes="上传收费单-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostDeliveryRecordPic iostDeliveryRecordPic) {
		iostDeliveryRecordPicService.save(iostDeliveryRecordPic);
		return Result.OK("添加成功！");
	}

	 /**
	  *  编辑
	  *
	  * @param iostDeliveryRecordPic
	  * @return
	  */
	 @AutoLog(value = "上传收费单-编辑")
	 @ApiOperation(value="上传收费单-编辑", notes="上传收费单-编辑")
	 @PutMapping(value = "/edit")
	 public Result<?> edit(@RequestBody IostDeliveryRecordPic iostDeliveryRecordPic) {
		 IostDeliveryRecordPic curPic = iostDeliveryRecordPicService.getById(iostDeliveryRecordPic.getId());
		 if(curPic==null) {
			 LambdaQueryWrapper<IostSummarySheet> query = new LambdaQueryWrapper<IostSummarySheet>().eq(IostSummarySheet::getDeliveryRecordId, iostDeliveryRecordPic.getId());
			 List<IostSummarySheet> iostSummarySheets = iostSummarySheetService.list(query);
			 List<String> iostSummarySheetIds = new ArrayList<String>();

			 for(IostSummarySheet iostSummarySheet:iostSummarySheets)
			 {
				 iostSummarySheetIds.add(iostSummarySheet.getId());
			 }

			 LambdaQueryWrapper<IostSummarySheetList> queryWrapper = new LambdaQueryWrapper<IostSummarySheetList>().in(IostSummarySheetList::getSummaryId, iostSummarySheetIds);
			 List<IostSummarySheetList> iostSummarySheetLists = iostSummarySheetListService.list(queryWrapper);
			 for(IostSummarySheetList iostSummarySheetList:iostSummarySheetLists)
			 {
				 iostSummarySheetList.setDeliverStatus("2");
			 }
			 iostSummarySheetListService.saveOrUpdateBatch(iostSummarySheetLists);

			 iostDeliveryRecordPicService.save(iostDeliveryRecordPic);
		 }
		 iostDeliveryRecordPicService.updateById(iostDeliveryRecordPic);
		 return Result.OK("编辑成功!");
	 }
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "上传收费单-通过id删除")
	@ApiOperation(value="上传收费单-通过id删除", notes="上传收费单-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostDeliveryRecordPicService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "上传收费单-批量删除")
	@ApiOperation(value="上传收费单-批量删除", notes="上传收费单-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostDeliveryRecordPicService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "上传收费单-通过id查询")
	@ApiOperation(value="上传收费单-通过id查询", notes="上传收费单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostDeliveryRecordPic iostDeliveryRecordPic = iostDeliveryRecordPicService.getById(id);
		if(iostDeliveryRecordPic==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostDeliveryRecordPic);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostDeliveryRecordPic
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostDeliveryRecordPic iostDeliveryRecordPic) {
        return super.exportXls(request, iostDeliveryRecordPic, IostDeliveryRecordPic.class, "上传收费单");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, IostDeliveryRecordPic.class);
    }

}
