package org.jeecg.modules.iost.basedata.controller;


import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.iost.basedata.entity.IostMessage;


import lombok.extern.slf4j.Slf4j;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 消息通知
 * @Author: jeecg-boot
 * @Date:   2020-11-26
 * @Version: V1.0
 */
@Api(tags="消息通知")
@RestController
@RequestMapping("/basedata/iostMessage")
@Slf4j
public class IostMessageController {
	
	@Autowired
	private ISysBaseAPI sysBaseAPI;
	
	/**
	 *   添加
	 *
	 * @param iostMessage
	 * @return
	 */
	@AutoLog(value = "发送消息通知")
	@ApiOperation(value="发送消息通知", notes="消息通知")
	@PostMapping(value = "/sendMessage")
	public Result<?> sendMessage(@RequestBody IostMessage iostMessage) {

		LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
		MessageDTO message = new MessageDTO();
		message.setFromUser(sysUser.getUsername());
		message.setToUser(iostMessage.getReceiver());
		message.setTitle(iostMessage.getTitle());
		message.setContent(iostMessage.getContent());
		sysBaseAPI.sendSysAnnouncement(message);
		
		return Result.OK("消息发送成功！");
	}
}
