package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: delivery_note_list
 * @Author: jeecg-boot
 * @Date:   2020-12-29
 * @Version: V1.0
 */
@ApiModel(value="iost_delivery_note对象", description="delivery note")
@Data
@TableName("iost_delivery_note_list")
public class IostDeliveryNoteList implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**Description*/
	@Excel(name = "Description", width = 15)
	@ApiModelProperty(value = "Description")
	private java.lang.String description;
	/**CTNS*/
	@Excel(name = "CTNS", width = 15)
	@ApiModelProperty(value = "CTNS")
	private java.lang.Integer ctns;
	/**Length*/
	@Excel(name = "Length", width = 15)
	@ApiModelProperty(value = "Length")
	private java.lang.Integer length;
	/**Width*/
	@Excel(name = "Width", width = 15)
	@ApiModelProperty(value = "Width")
	private java.lang.Integer width;
	/**Height*/
	@Excel(name = "Height", width = 15)
	@ApiModelProperty(value = "Height")
	private java.lang.Integer height;
	/**Dimensions*/
	@Excel(name = "Dimensions", width = 15)
	@ApiModelProperty(value = "Dimensions")
	private java.lang.Double dimensions;
	/**CBM*/
	@Excel(name = "CBM", width = 15)
	@ApiModelProperty(value = "CBM")
	private java.lang.Double cbm;
	/**Weight(kg)*/
	@Excel(name = "Weight(kg)", width = 15)
	@ApiModelProperty(value = "Weight(kg)")
	private java.lang.Double weight;
	/**MARK*/
	@Excel(name = "MARK", width = 15)
	@ApiModelProperty(value = "MARK")
	private java.lang.String mark;
	/**id*/
	@ApiModelProperty(value = "id")
	private java.lang.String deliveryNoteId;
}
