package org.jeecg.modules.iost.basedata.entity;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 汇总明细
 * @Author: jeecg-boot
 * @Date:   2020-12-22
 * @Version: V1.0
 */
@ApiModel(value="iost_summary_sheet对象", description="汇总单")
@Data
@TableName("iost_summary_sheet_list")
public class IostSummarySheetList implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**序列号*/
	@Excel(name = "序列号", width = 15)
	@ApiModelProperty(value = "序列号")
	private java.lang.String serialNumber;
	/**客户名称*/
	@Excel(name = "客户名称", width = 15)
	@ApiModelProperty(value = "客户名称")
	private java.lang.String customerName;
	/**体积*/
	@Excel(name = "体积", width = 15)
	@ApiModelProperty(value = "体积")
	private java.lang.Double volume;
	/**重量*/
	@Excel(name = "重量", width = 15)
	@ApiModelProperty(value = "重量")
	private java.lang.Double weight;
	/**箱数*/
	@Excel(name = "箱数", width = 15)
	@ApiModelProperty(value = "箱数")
	private java.lang.Integer packages;
	/**金额*/
	@Excel(name = "金额", width = 15)
	@ApiModelProperty(value = "金额")
	private java.lang.Double money;
	/**入仓号*/
	@Excel(name = "入仓号", width = 15)
	@ApiModelProperty(value = "入仓号")
	private java.lang.String receivingNo;
	/**送货状态*/
	@Excel(name = "送货状态", width = 15, dicCode = "delivery_status")
	@ApiModelProperty(value = "送货状态")
	private java.lang.String deliverStatus;

	/*public void setDeliverStatus(String deliverStatus) {
		this.deliverStatus=deliverStatus;
		switch (deliverStatus){
			case "1":
				this.deliverStatus = "待送货";
				break;
			case "2":
				this.deliverStatus = "已送货";
				break;
		}
	}*/

	/**汇总单id*/
	@ApiModelProperty(value = "汇总单id")
	private java.lang.String summaryId;
}
