package org.jeecg.modules.iost.basedata.vo;

import java.util.List;
import org.jeecg.modules.iost.basedata.entity.IostDeliverstatus;
import org.jeecg.modules.iost.basedata.entity.IostDeliverstatusList;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 更新物流状态
 * @Author: jeecg-boot
 * @Date:   2021-01-01
 * @Version: V1.0
 */
@Data
@ApiModel(value="iost_deliverstatusPage对象", description="更新物流状态")
public class IostDeliverstatusPage {

	/**主键*/
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**散货柜编号*/
	@Excel(name = "散货柜编号", width = 15)
	@ApiModelProperty(value = "散货柜编号")
	private java.lang.String bulkNo;
	/**货柜号*/
	@Excel(name = "货柜号", width = 15)
	@ApiModelProperty(value = "货柜号")
	private java.lang.String containerNo;
	/**装柜日期*/
	@Excel(name = "装柜日期", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
	@ApiModelProperty(value = "装柜日期")
	private java.util.Date loadingDate;
	/**出库Id*/
	@Excel(name = "出库Id", width = 15)
	@ApiModelProperty(value = "出库Id")
	private java.lang.String deliveryRecordId;

	@ExcelCollection(name="物流信息")
	@ApiModelProperty(value = "物流信息")
	private List<IostDeliverstatusList> iostDeliverstatusListList;

}
