package org.jeecg.modules.iost.basedata.vo;

import java.util.List;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecord;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryRecordList;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 出库记录
 * @Author: jeecg-boot
 * @Date:   2020-12-30
 * @Version: V1.0
 */
@Data
@ApiModel(value="iost_delivery_recordPage对象", description="出库记录")
public class IostDeliveryRecordPage {

	/**主键*/
	@ApiModelProperty(value = "主键")
	private java.lang.String id;
	/**创建人*/
	@ApiModelProperty(value = "创建人")
	private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建日期")
	private java.util.Date createTime;
	/**更新人*/
	@ApiModelProperty(value = "更新人")
	private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "更新日期")
	private java.util.Date updateTime;
	/**所属部门*/
	@ApiModelProperty(value = "所属部门")
	private java.lang.String sysOrgCode;
	/**散货柜编号*/
	@Excel(name = "散货柜编号", width = 15)
	@ApiModelProperty(value = "散货柜编号")
	private java.lang.String bulkNo;
	/**仓库名称*/
	@Excel(name = "仓库名称", width = 15, dictTable = "iost_storage", dicText = "name", dicCode = "id")
    @Dict(dictTable = "iost_storage", dicText = "name", dicCode = "id")
	@ApiModelProperty(value = "仓库名称")
	private java.lang.String warehouseName;
	/**货柜号*/
	@Excel(name = "货柜号", width = 15)
	@ApiModelProperty(value = "货柜号")
	private java.lang.String containerNo;
	/**总体积*/
	@Excel(name = "总体积", width = 15)
	@ApiModelProperty(value = "总体积")
	private java.lang.Double volumeTotals;
	/**总件数*/
	@Excel(name = "总件数", width = 15)
	@ApiModelProperty(value = "总件数")
	private java.lang.Integer packagesTotals;
	/**总重量*/
	@Excel(name = "总重量", width = 15)
	@ApiModelProperty(value = "总重量")
	private java.lang.Double weightTotals;
	/**总金额*/
	@Excel(name = "总金额", width = 15)
	@ApiModelProperty(value = "总金额")
	private java.lang.Double moneyTotal;
	/**装柜日期*/
	@Excel(name = "装柜日期", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
	@ApiModelProperty(value = "装柜日期")
	private java.util.Date loadingDate;
	/**送货单图片*/
	@Excel(name = "送货单图片", width = 15)
	@ApiModelProperty(value = "送货单图片")
	private java.lang.String deliveryRecordPics;

	@ExcelCollection(name="出库记录表")
	@ApiModelProperty(value = "出库记录表")
	private List<IostDeliveryRecordList> iostDeliveryRecordListList;

	/**地点*/
	@Excel(name = "地点", width = 15)
	@ApiModelProperty(value = "地点")
	private java.lang.String location;
	/**日期*/
	@Excel(name = "日期", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
	@DateTimeFormat(pattern="yyyy-MM-dd")
	@ApiModelProperty(value = "日期")
	private java.util.Date date;

}
