package org.jeecg.modules.iost.API.Dao;


import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * WEB-API
 */
@Slf4j
@Component
@Scope("prototype")
public class CategoryExecuteDao {
    static String K3CloudURL = "http://134.175.224.100/k3cloud/";//指定地址
    static String dbId = "6131d9fcd30ee9";
    static String uid = "kingdee";
    static String pwd = "kingdee@999";
    static int lang = 2052;
    String servicenameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";
    static String servicenameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";

    private String Stringwhere(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " AND " + key + "=" + value;
                } else {
                    where = key + "='" + value + "'";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + "\"";
        }
        return "";
    }

    /**
     * 查询日期
     *
     * @param map
     * @return
     */
    private String Stringwheredate(Map<String, String> map, String date) {
        String where = null;
        for (String key : map.keySet()) {
            //拿到日期
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " AND " + key + "=" + value;
                } else {
                    where = key + ">'" + value + "'" + "AND" + " " + key + "<'" + date + "'";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + "\"";
        }
        return "";
    }


    private String Stringkey(Map<String, String> map) {
        String Keys = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key;
                } else {
                    Keys = key;
                }
            }
        }
        if (Keys != null) {
            return "\"FieldKeys\":\"" + Keys + "\"";
        }
        return "";
    }

    /**
     * 查询单据体
     *
     * @return
     * @throws Exception
     */
    K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

    public List<List<Object>> select(String sFormId, Map<String, String> key, Map<String, String> where) {
        List<List<Object>> list = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwhere(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Map<String, List<List<Object>>> selectMap(String sFormId, Map<String, String> key, Map<String, String> where) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwhere(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringListHashMap;
    }

    public Map<String, List<List<Object>>> selectMapWhere(String sFormId, Map<String, String> key, String where) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + ",\"FilterString\":\"" + where + "\"" + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringListHashMap;
    }

    /**
     * 查询日期
     *
     * @param sFormId
     * @param key
     * @param where
     * @return
     */

    public Map<String, List<List<Object>>> selectdate(String sFormId, Map<String, String> key, Map<String, String> where, String date) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwheredate(where, date) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return stringListHashMap;
    }

    public String add(String sFormId, String json) {
        String result2 = null;
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content = "{\"Model\":" + json + "}";
                result2 = client.save(sFormId, content);
            }
        } catch (Exception e) {
            log.debug(String.valueOf(e));
        }
        return result2;
    }

    //拼接content-查找今天的数据
    private String TodayContent() {
        //今日凌晨0点
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(new Date());
        calendar1.set(Calendar.HOUR_OF_DAY, 0);
        calendar1.set(Calendar.MINUTE, 0);
        calendar1.set(Calendar.SECOND, 0);
        Date Ysterdayzerotime1 = calendar1.getTime();
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString1 = formatter1.format(Ysterdayzerotime1);


        //今日晚上12点
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 24);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date Ysterdayzerotime = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(Ysterdayzerotime);

        // String content="FCreateDate >"+"\'"+"2021-08-21 00:00:00"+"\'"+" AND FCreateDate < "+"\'"+dateString+"\'";
        String content = "FCreateDate >" + "\'" + dateString1 + "\'" + " AND FCreateDate < " + "\'" + dateString + "\'";
        return ",\"FilterString\":\"" + content + "\"";
    }

    /**
     * 查询单据体-查询今日之内的数据-返回星空云请求数据和响应信息
     *
     * @return
     * @throws
     */
    public Map<String, List<List<Object>>> selectTodayAndReturnNew(String sFormId, Map<String, String> key) {
        List<List<Object>> list = null;
        String contentTody = TodayContent();
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<>();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            String content;
            if (result) {

                content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + contentTody + "}";

                list = client.executeBillQuery(content);
                stringListHashMap.put(content, list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringListHashMap;
    }

    public List<Object> selectTodayAndReturn(String sFormId, Map<String, String> key) {
        List<List<Object>> list = null;
        List<Object> lists = new ArrayList<>();

        String contentTody = TodayContent();
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content;
                content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + contentTody + "}";
                lists.add(content);
                list = client.executeBillQuery(content);
                lists.add(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }

    private String StringkeyByList(List<String> list) {
        String Keys = null;

        for (String key : list) {
            String value = String.valueOf(key);
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key;
                } else {
                    Keys = key;
                }
            }
        }
        if (Keys != null) {
            return  Keys ;
        }
        return "";
    }

    public Map<String, List<Map>> selectInList(String f_sFormId, List<String> lists, Map<String, String> where) {
        Map<String, List<Map>> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<Map> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "SELECT " + StringkeyByList(lists) + " FROM " + f_sFormId + StringWhereCompare(where);

                } else {
                    content = "SELECT " + StringkeyByList(lists) + " FROM " + f_sFormId;

                }
                String[] strings = new String[]{content};
                System.out.println("content"+content);
                list = client.execute(servicenameMap, strings, List.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

    public Map<String, List<List<Object>>> selectWhere(String sFormId, List<String> lists, String where) {
        Map<String, List<List<Object>>> log = new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<List<Object>> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + ",\"FilterString\":\"" + where + "\"" + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + "}";
                }

                list = client.executeBillQuery(content);

            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            log.put(content, list);//请求数据做key,返回做value
        }
        return log;
    }

    public static String StringWhereCompare(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if (value != null && value != "") {
                if (where != null) {
                    where = where + " AND " + key + value;
                } else {
                    where = key + "" + value + "";
                }
            }
        }
        if (where != null) {
            return " where " + where + "";
        }
        return "";
    }

    public List<List<Object>> select(String content) {
        //请求
        List<List<Object>> list = null;//响应
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                list = client.executeBillQuery(content);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

}

