package org.jeecg.modules.iost.API.ExternalInterface;

import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.Util.EipUtil;
import org.jeecg.modules.iost.API.Util.HttpUtil;
import org.jeecg.modules.iost.API.Util.HttpUtils;
import org.jeecg.modules.iost.API.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 排产计划
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Component
public class ProductionSchedulingApi implements API {
    private String url = "http://www.lingqingkeji.com:8080/wmssystem/API/supplier-production-schedule/";
    private List<Map<String, Object>> lists = new ArrayList<Map<String,Object>>();
    Map<String,String> hreader=new HashMap<>();

    public ProductionSchedulingApi()
    {
        hreader.put("transno", EipUtil.getTransno());
        hreader.put("orisys", "0");
        hreader.put("Content-Type","application/json");
    }

    @Override
    public String add(Map<String,String> map) {
        hreader.put("operatetype","add");
        String result = null;
        try {
            result = HttpUtil.post(url+"add", JsonUtil.Mapjson(map),hreader);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String select() {
        hreader.put("operatetype","select");
        String result = HttpUtils.getRequest(url+"list", hreader, null);
        return result;
    }

}
